/*
 * Copyright (C) 2019 ~ 2019 Deepin Technology Co., Ltd.
 *
 * Author:     justforlxz <justforlxz@outlook.com>
 *
 * Maintainer: justforlxz <justforlxz@outlook.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "interface/moduleinterface.h"

#include <QObject>

namespace dcc {
namespace unionid {
class UnionidWorker;
class UnionidModel;
}
}

namespace DCC_NAMESPACE {
namespace unionid {
class UnionidModule : public QObject, public ModuleInterface
{
    Q_OBJECT
public:
    UnionidModule(FrameProxyInterface *frameProxy, QObject *parent = nullptr);

    virtual void initialize() override;
    virtual const QString name() const override;
    virtual const QString displayName() const override;
    virtual void contentPopped(QWidget *const w) override;
    virtual void active() override;
    virtual void preInitialize(bool sync = false , FrameProxyInterface::PushType = FrameProxyInterface::PushType::Normal) override;
    QStringList availPage() const override;
public Q_SLOTS:
    void onShowPopup(QString fileName); // for user exprience program
private:
    dcc::unionid::UnionidModel  *m_model;
    dcc::unionid::UnionidWorker *m_worker;
};
} // namespace sync
} // namespace DCC_NAMESPACE
