#include "passwordresetwidget.h"
#include "passwordresetthread.h"

#include <QVBoxLayout>
#include <QTimer>
#include <QDebug>
#include <QDir>
#include <QApplication>

PasswordResetWidget::PasswordResetWidget(QWidget *parent)
    : QWidget(parent)

    , m_icon(new QLabel)
    , m_tips(new QLabel)
    , m_status(new QLabel)
    , m_resetButton(new QPushButton)
    , m_confirmButton(new QPushButton)
    , m_okButton(new QPushButton)
    , m_userChooseBox(new QComboBox)
    , m_passwordEdit(new DPasswordEdit)
    , m_passwordRepeat(new DPasswordEdit)
    , m_tipsText("")
{
    m_icon->setPixmap(QIcon(":/resources/repair_password.svg").pixmap(128, 128));
    m_icon->setAlignment(Qt::AlignHCenter);
    m_icon->setObjectName("PluginIcon");
    m_tips->setAlignment(Qt::AlignHCenter);
    m_tips->setObjectName("TipsLabel");
    m_status->setAlignment(Qt::AlignHCenter);
    m_resetButton->setText(tr("Reset password"));
    m_confirmButton->setText(tr("Confirm"));
    m_okButton->setText(tr("Done"));
    m_passwordEdit->lineEdit()->setPlaceholderText(tr("Password"));
    m_passwordRepeat->lineEdit()->setPlaceholderText(tr("Confirm password"));
    m_passwordEdit->setStyleSheet(
                //正常状态样式
                "QPushButton{"
                "background-color:rgba(1,128,255,255);"//背景色（也可以设置图片）
                "border-style:outset;"                  //边框样式（inset/outset）
                "border-width:4px;"                     //边框宽度像素
                "border-radius:10px;"                   //边框圆角半径像素
                "border-color:rgba(255,255,255,30);"    //边框颜色
                "font:bold 10px;"                       //字体，字体大小
                "color:rgba(0,0,0,100);"                //字体颜色
                "padding:6px;"                          //填衬
                "}"
                //鼠标按下样式
                "QPushButton:pressed{"
                "background-color:rgba(100,255,100,200);"
                "border-color:rgba(255,255,255,30);"
                "border-style:inset;"
                "color:rgba(0,0,0,100);"
                "}"
                //鼠标悬停样式
                "QPushButton:hover{"
                "background-color:rgba(1,128,255,255);"
                "border-color:rgba(255,255,255,200);"
                "color:rgba(0,0,0,200);"
                "}");
    m_passwordRepeat->setStyleSheet(
                //正常状态样式
                "QPushButton{"
                "background-color:rgba(1,128,255,255);"//背景色（也可以设置图片）
                "border-style:outset;"                  //边框样式（inset/outset）
                "border-width:4px;"                     //边框宽度像素
                "border-radius:10px;"                   //边框圆角半径像素
                "border-color:rgba(255,255,255,30);"    //边框颜色
                "font:bold 10px;"                       //字体，字体大小
                "color:rgba(0,0,0,100);"                //字体颜色
                "padding:6px;"                          //填衬
                "}"
                //鼠标按下样式
                "QPushButton:pressed{"
                "background-color:rgba(100,255,100,200);"
                "border-color:rgba(255,255,255,30);"
                "border-style:inset;"
                "color:rgba(0,0,0,100);"
                "}"
                //鼠标悬停样式
                "QPushButton:hover{"
                "background-color:rgba(1,128,255,255);"
                "border-color:rgba(255,255,255,200);"
                "color:rgba(0,0,0,200);"
                "}");

    QHBoxLayout *btnsLayout = new QHBoxLayout;
    btnsLayout->addStretch();
    btnsLayout->addWidget(m_resetButton);
    btnsLayout->addWidget(m_confirmButton);
    btnsLayout->addWidget(m_okButton);
    btnsLayout->addStretch();

    QVBoxLayout *centralLayout = new QVBoxLayout;
    centralLayout->addWidget(m_icon);
    centralLayout->addSpacing(10);
    centralLayout->addWidget(m_tips);
    centralLayout->addSpacing(5);
    centralLayout->addWidget(m_userChooseBox);
    centralLayout->setAlignment(m_userChooseBox, Qt::AlignHCenter);
    centralLayout->addSpacing(5);
    centralLayout->addWidget(m_passwordEdit);
    centralLayout->setAlignment(m_passwordEdit, Qt::AlignHCenter);
    centralLayout->addSpacing(5);
    centralLayout->addWidget(m_passwordRepeat);
    centralLayout->setAlignment(m_passwordRepeat, Qt::AlignHCenter);
    centralLayout->addStretch();
    centralLayout->addWidget(m_status);
    centralLayout->addSpacing(10);
    centralLayout->addLayout(btnsLayout);
    centralLayout->setSpacing(0);
    centralLayout->setContentsMargins(0, 0, 0, 0);

    setLayout(centralLayout);

    connect(m_resetButton, &QPushButton::clicked, this, &PasswordResetWidget::onResetClicked);
    connect(m_confirmButton, &QPushButton::clicked, this, &PasswordResetWidget::onPasswdSubmitted);
    connect(m_okButton, &QPushButton::clicked, this, &PasswordResetWidget::resetUI);
    connect(m_passwordEdit, &DPasswordEdit::textEdited, this, &PasswordResetWidget::onPasswordChanged);
    connect(m_passwordRepeat, &DPasswordEdit::textEdited, this, &PasswordResetWidget::onPasswordChanged);

    QTimer::singleShot(1, this, &PasswordResetWidget::initUserInfo);
    QTimer::singleShot(1, this, &PasswordResetWidget::resetUI);
}

void PasswordResetWidget::showEvent(QShowEvent *e)
{
    QWidget::showEvent(e);

    m_resetButton->setFocus();
}

void PasswordResetWidget::changeEvent(QEvent* event)
{
    if (event->type() == QEvent::LanguageChange) {
        m_resetButton->setText(tr("Reset password"));
        m_confirmButton->setText(tr("Confirm"));
        m_okButton->setText(tr("Done"));
        m_status->setText(tr("Reset password successfully"));
        m_passwordEdit->lineEdit()->setPlaceholderText(tr("Password"));
        m_passwordRepeat->lineEdit()->setPlaceholderText(tr("Confirm password"));
        m_tips->setText(tr(m_tipsText.toStdString().c_str()));
    } else {
        QWidget::changeEvent(event);
    }
}

void PasswordResetWidget::onResetClicked()
{
    m_tips->setText(tr("Please enter a new password"));
    m_resetButton->setVisible(false);
    m_confirmButton->setVisible(true);

    m_passwordEdit->setVisible(true);
    m_passwordRepeat->setVisible(true);

    if (m_userChooseBox->count() > 1)
        m_userChooseBox->setVisible(true);
}

void PasswordResetWidget::onPasswdSubmitted()
{
    const QString &pwd1 = m_passwordEdit->text();
    const QString &pwd2 = m_passwordRepeat->text();
    if (pwd1 != pwd2)
        return m_passwordRepeat->showAlertMessage(tr("Passwords do not match"));

    m_confirmButton->setVisible(false);
    m_okButton->setVisible(false);
    m_tips->setVisible(false);

    m_userChooseBox->setVisible(false);
    m_passwordEdit->setVisible(false);
    m_passwordRepeat->setVisible(false);

    resetUserPassword();
}

void PasswordResetWidget::resetUserPassword()
{
    const auto data = m_userChooseBox->currentText();

    PasswordResetThread *thrd = new PasswordResetThread;
    thrd->setToolsProxy(m_toolsProxy);
    // Base64 encoding password to escape characters
    const QString encoded_password = m_passwordEdit->text().toUtf8();
    thrd->setTaskInfo("/target", data, encoded_password);

    connect(thrd, &PasswordResetThread::finished, thrd, &PasswordResetThread::deleteLater, Qt::QueuedConnection);
    connect(thrd, &PasswordResetThread::finished, this, &PasswordResetWidget::onResetPasswordFinished);

    thrd->start();
}

void PasswordResetWidget::onResetPasswordFinished()
{
    m_okButton->setVisible(true);
    m_status->setVisible(true);
    m_status->setText(tr("Reset password successfully"));
    m_status->setStyleSheet("color: #3da219;");
}

void PasswordResetWidget::onPasswordChanged(const QString &pwd)
{
    if (!m_passwordEdit->text().isEmpty() && !m_passwordRepeat->text().isEmpty()) {
         m_confirmButton->setEnabled(true);
         return ;
    }
    m_confirmButton->setEnabled(false);
}
void PasswordResetWidget::initUserInfo()
{
    QDir dir( "/target/home/");
    QFileInfoList fileInfoList = dir.entryInfoList();
    for (QFileInfo fileInfo : fileInfoList) {
        if (fileInfo.fileName() == "." || fileInfo.fileName() == "..")  continue;
        if (fileInfo.isDir()) {
            if (fileInfo.fileName() == "lost+found") continue;
            m_userChooseBox->addItem(fileInfo.fileName(), fileInfo.fileName());
        }

    }


}

void PasswordResetWidget::resetUI()
{
    m_passwordEdit->clear();
    m_passwordRepeat->clear();

    m_tips->setText(tr("Forgot login password"));
    m_tips->setVisible(true);
    m_status->setVisible(false);
    m_resetButton->setVisible(true);
    m_confirmButton->setVisible(false);
    m_okButton->setVisible(false);
    m_userChooseBox->setVisible(true);
    m_passwordEdit->setVisible(false);
    m_passwordRepeat->setVisible(false);

    onPasswordChanged(QString());
}
