package audio

import (
	"reflect"

	"pkg.deepin.io/daemon/sync/infrastructure/utils"
	. "pkg.deepin.io/daemon/sync/modules/model"
)

type soundEffect struct {
	Enabled                 bool `json:"enabled"`
	AudioVolumeChange       bool `json:"audio_volume_change"`
	CameraShutter           bool `json:"camera_shutter"`
	CompleteCopy            bool `json:"complete_copy"`
	CompletePrint           bool `json:"complete_print"`
	DesktopLogin            bool `json:"desktop_login"`
	DesktopLogout           bool `json:"desktop_logout"`
	DeviceAdded             bool `json:"device_added"`
	DeviceRemoved           bool `json:"device_removed"`
	DialogErrorCritical     bool `json:"dialog_error_critical"`
	DialogError             bool `json:"dialog_error"`
	DialogErrorSerious      bool `json:"dialog_error_serious"`
	Message                 bool `json:"message"`
	PowerPlug               bool `json:"power_plug"`
	PowerUnplug             bool `json:"power_unplug"`
	PowerUnplugBatteryLow   bool `json:"power_unplug_battery_low"`
	ScreenCaptureComplete   bool `json:"screen_capture_complete"`
	ScreenCapture           bool `json:"screen_capture"`
	SuspendResume           bool `json:"suspend_resume"`
	SystemShutdown          bool `json:"system_shutdown"`
	TrashEmpty              bool `json:"trash_empty"`
	XDeepinAppSentToDesktop bool `json:"x_deepin_app_sent_to_desktop"`
}

type Data struct {
	Version     string       `json:"version"`
	SoundEffect *soundEffect `json:"soundeffect"`
}

const (
	Name = "audio"
)

func (core *Data) Name() string {
	return Name
}

func (core *Data) Model() interface{} {
	return &Data{}
}

func (core *Data) ToIFC(v interface{}) DataIFC {
	return v.(*Data)
}

func (core *Data) Equal(target DataIFC) bool {
	info := target.(*Data)
	return reflect.DeepEqual(core, info)
}

func (core *Data) GenCache(DataIFC) DataIFC {
	return core
}

func (core *Data) Merge(current, cache DataIFC) {
	curInfo := current.(*Data)
	cacheInfo := cache.(*Data)
	utils.MergeBool(&core.SoundEffect.Enabled, curInfo.SoundEffect.Enabled,
		cacheInfo.SoundEffect.Enabled)
	utils.MergeBool(&core.SoundEffect.AudioVolumeChange, curInfo.SoundEffect.AudioVolumeChange,
		cacheInfo.SoundEffect.AudioVolumeChange)
	utils.MergeBool(&core.SoundEffect.CameraShutter, curInfo.SoundEffect.CameraShutter,
		cacheInfo.SoundEffect.CameraShutter)
	utils.MergeBool(&core.SoundEffect.CompleteCopy, curInfo.SoundEffect.CompleteCopy,
		cacheInfo.SoundEffect.CompleteCopy)
	utils.MergeBool(&core.SoundEffect.CompletePrint, curInfo.SoundEffect.CompletePrint,
		cacheInfo.SoundEffect.CompletePrint)
	utils.MergeBool(&core.SoundEffect.DesktopLogin, curInfo.SoundEffect.DesktopLogin,
		cacheInfo.SoundEffect.DesktopLogin)
	utils.MergeBool(&core.SoundEffect.DesktopLogout, curInfo.SoundEffect.DesktopLogout,
		cacheInfo.SoundEffect.DesktopLogout)
	utils.MergeBool(&core.SoundEffect.DeviceAdded, curInfo.SoundEffect.DeviceAdded,
		cacheInfo.SoundEffect.DeviceAdded)
	utils.MergeBool(&core.SoundEffect.DeviceRemoved, curInfo.SoundEffect.DeviceRemoved,
		cacheInfo.SoundEffect.DeviceRemoved)
	utils.MergeBool(&core.SoundEffect.DialogError, curInfo.SoundEffect.DialogError,
		cacheInfo.SoundEffect.DialogError)
	utils.MergeBool(&core.SoundEffect.DialogErrorCritical, curInfo.SoundEffect.DialogErrorCritical,
		cacheInfo.SoundEffect.DialogErrorCritical)
	utils.MergeBool(&core.SoundEffect.DialogErrorSerious, curInfo.SoundEffect.DialogErrorSerious,
		cacheInfo.SoundEffect.DialogErrorSerious)
	utils.MergeBool(&core.SoundEffect.Message, curInfo.SoundEffect.Message,
		cacheInfo.SoundEffect.Message)
	utils.MergeBool(&core.SoundEffect.PowerPlug, curInfo.SoundEffect.PowerPlug,
		cacheInfo.SoundEffect.PowerPlug)
	utils.MergeBool(&core.SoundEffect.PowerUnplug, curInfo.SoundEffect.PowerUnplug,
		cacheInfo.SoundEffect.PowerUnplug)
	utils.MergeBool(&core.SoundEffect.PowerUnplugBatteryLow, curInfo.SoundEffect.PowerUnplugBatteryLow,
		cacheInfo.SoundEffect.PowerUnplugBatteryLow)
	utils.MergeBool(&core.SoundEffect.ScreenCapture, curInfo.SoundEffect.ScreenCapture,
		cacheInfo.SoundEffect.ScreenCapture)
	utils.MergeBool(&core.SoundEffect.ScreenCaptureComplete, curInfo.SoundEffect.ScreenCaptureComplete,
		cacheInfo.SoundEffect.ScreenCaptureComplete)
	utils.MergeBool(&core.SoundEffect.SuspendResume, curInfo.SoundEffect.SuspendResume,
		cacheInfo.SoundEffect.SuspendResume)
	utils.MergeBool(&core.SoundEffect.SystemShutdown, curInfo.SoundEffect.SystemShutdown,
		cacheInfo.SoundEffect.SystemShutdown)
	utils.MergeBool(&core.SoundEffect.TrashEmpty, curInfo.SoundEffect.TrashEmpty,
		cacheInfo.SoundEffect.TrashEmpty)
	utils.MergeBool(&core.SoundEffect.XDeepinAppSentToDesktop, curInfo.SoundEffect.XDeepinAppSentToDesktop,
		cacheInfo.SoundEffect.XDeepinAppSentToDesktop)
}
