package background

import (
	"reflect"
	"testing"
)

var (
	_file1 = File{
		URI:       "file:///tmp/1.png",
		CloudName: "workspace0",
		Md5:       "1.png",
	}
	_file2 = File{
		URI:       "file:///tmp/1.png",
		CloudName: "workspace1",
		Md5:       "1.png",
	}
	_file3 = File{
		URI:       "file:///tmp/2.png",
		CloudName: "workspace2",
		Md5:       "2.png",
	}
	_greeter = File{
		URI:       "file:///tmp/1.png",
		CloudName: "greeter",
		Md5:       "1.png",
	}
	_core1 = Data{
		Workspace: FileList{&_file1, &_file2},
		Greeter:   &_greeter,
	}
	_core2 = Data{
		Workspace: FileList{&_file1, &_file2, &_file3},
		Greeter:   &_greeter,
	}
)

func TestName(t *testing.T) {
	var core = &Data{}
	if core.Name() != "background" {
		panic("[TestName] name should be equal")
	}
}

func TestModel(t *testing.T) {
	var core = &Data{}
	if !reflect.DeepEqual(core, core.Model()) {
		panic("[TestModel] model should be equal")
	}
}

func TestToIFC(t *testing.T) {
	var tmp = &Data{}
	if !reflect.DeepEqual(tmp.ToIFC(&_core1), &_core1) {
		panic("[TestToIFC] ToIFC should be equal")
	}
	if reflect.DeepEqual(tmp.ToIFC(&_core1), tmp) {
		panic("[TestToIFC] ToIFC should be not equal with tmp")
	}
}

func TestEqual(t *testing.T) {
	var core = _core1
	if !(&core).Equal(&_core1) {
		panic("[TestEqual] core and core1 should be equal")
	}
	core.Greeter = &_file1
	if (&core).Equal(&_core1) {
		panic("[TestEqual] core and core1 should be not equal after modified")
	}
	core.Greeter = &_greeter
	if !(&core).Equal(&_core2) {
		panic("[TestEqual] core and core2 should be equal")
	}
}

func TestGenCache(t *testing.T) {
	core := _core1
	tmp := (&core).GenCache(&Data{}).(*Data)
	if len(tmp.Workspace) != 0 {
		panic("[TestGenCache] core's workspace should be nil")
	}
	if !reflect.DeepEqual((&_core2).GenCache(&_core1), &_core1) {
		panic("[TestGenCahce] core1 should be equal with the cache")
	}
}

func TestMerge(t *testing.T) {
	var core = _core1
	(&core).Merge(&_core2, &_core1)
	if !reflect.DeepEqual(&core, &_core2) {
		panic("[TestMerge] core(added) should be equal with core2")
	}
	core = _core2
	(&core).Merge(&_core1, &_core2)
	if !reflect.DeepEqual(&core, &_core2) {
		panic("[TestMerge] core(removed) should be equal with core2")
	}
	tmp1 := _core1
	tmp2 := _core2
	tmp1.Greeter = &_file1
	(&core).Merge(&tmp1, &tmp2)
	tmp2.Greeter = &_file1
	if !reflect.DeepEqual(&core, &tmp2) {
		panic("[TestMerge] core(removed) should be equal with tmp2")
	}
}

func TestNewData(t *testing.T) {
	files := []string{
		"file:///tmp/1.png",
		"file:///tmp/1.png",
	}
	core := NewData(files, "file:///tmp/1.png")
	core1 := Data{Workspace: FileList{&_file1, &_file2}, Greeter: &_greeter}
	if !reflect.DeepEqual(core, &core1) {
		panic("[TestNewData] new data should be equal with core1")
	}
	core = NewData(files, "")
	core1 = Data{Workspace: FileList{&_file1, &_file2}, Greeter: &File{}}
	if !reflect.DeepEqual(core, &core1) {
		panic("[TestNewData] new data(no greeter) should be equal with core1")
	}
	if !reflect.DeepEqual(core.Workspace.Files(), files) {
		panic("[TestNewData] files should be equal")
	}
}
