package network

import (
	"reflect"
	"testing"
)

var (
	_conn1 = &Connection{
		Type:     "wifi",
		Filename: "deepin",
		Contents: []byte("deepin123456"),
	}
	_conn2 = &Connection{
		Type:     "wifi",
		Filename: "deepin_5G",
		Contents: []byte("deepin123456323121"),
	}
	_conn3 = &Connection{
		Type:     "wifi",
		Filename: "deepin-guest",
		Contents: []byte("deepin-guest12323"),
	}
	_core1 = Data{
		Connections: ConnectionList{_conn1, _conn2},
	}
	_core2 = Data{
		Connections: ConnectionList{_conn1, _conn2},
	}
	_core3 = Data{
		Connections: ConnectionList{_conn1, _conn2, _conn3},
	}
)

func TestName(t *testing.T) {
	var core = &Data{}
	if core.Name() != "network" {
		panic("[TestName] name should be equal")
	}
}

func TestModel(t *testing.T) {
	var core = &Data{}
	if !reflect.DeepEqual(core, core.Model()) {
		panic("[TestModel] model should be equal")
	}
}

func TestToIFC(t *testing.T) {
	var tmp = &Data{}
	if !reflect.DeepEqual(tmp.ToIFC(&_core1), &_core1) {
		panic("[TestToIFC] ToIFC should be equal")
	}
}

func TestEqual(t *testing.T) {
	if !(&_core1).Equal(&_core2) {
		panic("[TestEqual] core1 and core2 should be equal")
	}
	if (&_core1).Equal(&_core3) {
		panic("[TestEqual] core1 and core3 should be not equal")
	}
}

func TestGenCache(t *testing.T) {
	var core = &Data{
		Connections: ConnectionList{_conn1},
	}
	if !reflect.DeepEqual(core.GenCache(&_core1), core) {
		panic("[TestGenCache] core and core1 should be equal")
	}
}

func TestMerge(t *testing.T) {
	tmp1 := &Data{Connections: ConnectionList{_conn1, _conn3}}
	tmp1.Merge(&_core1, &_core3)
	core := Data{Connections: ConnectionList{_conn1}}
	if !reflect.DeepEqual(tmp1, &core) {
		panic("[TestMerge] tmp1 should be equal with core")
	}
	tmp2 := &Data{Connections: ConnectionList{_conn1, _conn2}}
	_core3.Connections[0] = &Connection{
		Type:     "wifi",
		Filename: "deepin",
		Contents: []byte("testmodified"),
	}
	tmp2.Merge(&_core3, &_core1)
	if !reflect.DeepEqual(tmp2, &_core3) {
		panic("[TestMerge] tmp2 should be equal with core3")
	}
}
