/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.RestrictedStringValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue("");
    protected CharSequence value;
    protected int length = -1;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$StringValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    protected StringValue() {
        this.value = "";
    }

    public StringValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : charSequence;
    }

    public final String getStringValue() {
        this.value = this.value.toString();
        return this.value;
    }

    public AtomicValue convert(int n) throws XPathException {
        String string = Value.trimWhitespace(this.value).toString();
        switch (n) {
            case 514: {
                if (string.equals("0") || string.equals("false")) {
                    return BooleanValue.FALSE;
                }
                if (string.equals("1") || string.equals("true")) {
                    return BooleanValue.TRUE;
                }
                throw new XPathException.Dynamic("The string \u00ab" + string + "\u00bb cannot be cast to a boolean");
            }
            case 646: {
                try {
                    if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
                        double d = new Double(string);
                        return new DoubleValue(d);
                    }
                    if (string.indexOf(46) >= 0 || string.length() > 18) {
                        return new DecimalValue(string);
                    }
                    long l = new Long(string);
                    return new IntegerValue(l);
                }
                catch (NumberFormatException numberFormatException) {
                    string = this.shorten(string);
                    throw new XPathException.Dynamic("Cannot convert string \u00ab" + string + "\u00bb to a number");
                }
            }
            case 517: {
                try {
                    return new DoubleValue(Value.stringToNumber(string));
                }
                catch (NumberFormatException numberFormatException) {
                    string = this.shorten(string);
                    throw new XPathException.Dynamic("Cannot convert string \u00ab" + string + "\u00bb to a double");
                }
            }
            case 532: {
                return new IntegerValue(Value.stringToInteger(string));
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                return new IntegerValue(Value.stringToInteger(this.value), (AtomicType)BuiltInSchemaFactory.getSchemaType(n));
            }
            case 515: {
                return new DecimalValue(this.value);
            }
            case 516: {
                try {
                    return new FloatValue((float)Value.stringToNumber(this.value));
                }
                catch (NumberFormatException numberFormatException) {
                    string = this.shorten(string);
                    throw new XPathException.Dynamic("Cannot convert string \u00ab" + string + "\u00bb to a float");
                }
            }
            case 521: {
                return new DateValue(this.value);
            }
            case 519: {
                return new DateTimeValue(this.value);
            }
            case 520: {
                return new TimeValue(this.value);
            }
            case 523: {
                return new GYearValue(this.value);
            }
            case 522: {
                return new GYearMonthValue(this.value);
            }
            case 526: {
                return new GMonthValue(this.value);
            }
            case 524: {
                return new GMonthDayValue(this.value);
            }
            case 525: {
                return new GDayValue(this.value);
            }
            case 518: {
                return new DurationValue(this.value);
            }
            case 644: {
                return new MonthDurationValue(this.value);
            }
            case 645: {
                return new SecondsDurationValue(this.value);
            }
            case 593: 
            case 642: {
                return new UntypedAtomicValue(this.value);
            }
            case 88: 
            case 513: 
            case 643: {
                return this;
            }
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                return new RestrictedStringValue(this.value, n);
            }
            case 529: {
                return new AnyURIValue(this.value);
            }
            case 527: {
                return new HexBinaryValue(this.value);
            }
            case 528: {
                return new Base64BinaryValue(this.value);
            }
        }
        throw new XPathException.Dynamic("Cannot convert string to " + StandardNames.getDisplayName(n));
    }

    private String shorten(String string) {
        if (string.length() > 30) {
            string = string.substring(0, 30) + "...";
        }
        return string;
    }

    public ItemType getItemType() {
        return Type.STRING_TYPE;
    }

    public int getLength() {
        if (this.length == -1) {
            this.length = StringValue.getLength(this.value);
        }
        return this.length;
    }

    public static int getLength(CharSequence charSequence) {
        int n = 0;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            char c = charSequence.charAt(n2);
            if (c < '\ud800' || c > '\udbff') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public SequenceIterator iterateCharacters() {
        return new CharacterIterator();
    }

    public static int[] expand(CharSequence charSequence) {
        int[] nArray = new int[StringValue.getLength(charSequence)];
        int n = 0;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            int n3;
            int n4 = charSequence.charAt(n2);
            if (n4 >= 55296 && n4 <= 56319) {
                n3 = (n4 - 55296) * 1024 + (charSequence.charAt(n2 + 1) - 56320) + 65536;
                ++n2;
            } else {
                n3 = n4;
            }
            nArray[n++] = n3;
            ++n2;
        }
        return nArray;
    }

    public boolean equals(Object object) {
        return this.getStringValue().equals(((StringValue)object).getStringValue());
    }

    public int hashCode() {
        return this.getStringValue().hashCode();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value.length() > 0;
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = StringValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$StringValue == null ? (class$net$sf$saxon$value$StringValue = StringValue.class$("net.sf.saxon.value.StringValue")) : class$net$sf$saxon$value$StringValue)) {
            return 0;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = StringValue.class$("java.lang.String")) : class$java$lang$String)) {
            return 1;
        }
        if (clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = StringValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 1;
        }
        if (clazz == Boolean.TYPE) {
            return 16;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = StringValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 17;
        }
        if (clazz == Byte.TYPE) {
            return 18;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = StringValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 19;
        }
        if (clazz == Character.TYPE) {
            return 2;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = StringValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return 3;
        }
        if (clazz == Double.TYPE) {
            return 6;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = StringValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 7;
        }
        if (clazz == Float.TYPE) {
            return 8;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = StringValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 9;
        }
        if (clazz == Integer.TYPE) {
            return 10;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = StringValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 11;
        }
        if (clazz == Long.TYPE) {
            return 12;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = StringValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 13;
        }
        if (clazz == Short.TYPE) {
            return 14;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = StringValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 15;
        }
        return super.conversionPreference(clazz);
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = StringValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.value;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$StringValue == null ? (class$net$sf$saxon$value$StringValue = StringValue.class$("net.sf.saxon.value.StringValue")) : class$net$sf$saxon$value$StringValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = StringValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = StringValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.value;
        }
        if (clazz == Boolean.TYPE) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514);
            return new Boolean(booleanValue.getValue());
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = StringValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514);
            return new Boolean(booleanValue.getValue());
        }
        if (clazz == Double.TYPE) {
            DoubleValue doubleValue = (DoubleValue)this.convert(517);
            return new Double(doubleValue.getValue());
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = StringValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            DoubleValue doubleValue = (DoubleValue)this.convert(517);
            return new Double(doubleValue.getValue());
        }
        if (clazz == Float.TYPE) {
            DoubleValue doubleValue = (DoubleValue)this.convert(517);
            return new Float(doubleValue.getValue());
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = StringValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            DoubleValue doubleValue = (DoubleValue)this.convert(517);
            return new Float(doubleValue.getValue());
        }
        if (clazz == Long.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(532);
            return new Long(integerValue.getValue());
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = StringValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            IntegerValue integerValue = (IntegerValue)this.convert(532);
            return new Long(integerValue.getValue());
        }
        if (clazz == Integer.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(532);
            return new Integer((int)integerValue.getValue());
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = StringValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            IntegerValue integerValue = (IntegerValue)this.convert(532);
            return new Integer((int)integerValue.getValue());
        }
        if (clazz == Short.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(532);
            return new Short((short)integerValue.getValue());
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = StringValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            IntegerValue integerValue = (IntegerValue)this.convert(532);
            return new Short((short)integerValue.getValue());
        }
        if (clazz == Byte.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(532);
            return new Byte((byte)integerValue.getValue());
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = StringValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            IntegerValue integerValue = (IntegerValue)this.convert(532);
            return new Byte((byte)integerValue.getValue());
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = StringValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            if (this.value.length() == 1) {
                return new Character(this.value.charAt(0));
            }
            throw new XPathException.Dynamic("Cannot convert string to Java char unless length is 1");
        }
        Object object = super.convertToJava(clazz);
        if (object == null) {
            throw new XPathException.Dynamic("Conversion of string to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "string \u00ab" + this.value + "\u00bb");
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class CharacterIterator
    implements SequenceIterator {
        int pos = 0;
        int current;

        public Item next() {
            if (this.pos < StringValue.this.value.length()) {
                char c;
                this.current = (c = StringValue.this.value.charAt(this.pos++)) >= '\ud800' && c <= '\udbff' ? (c - 55296) * 1024 + (StringValue.this.value.charAt(this.pos++) - 56320) + 65536 : (int)c;
                return new IntegerValue(this.current);
            }
            return null;
        }

        public Item current() {
            return new IntegerValue(this.current);
        }

        public int position() {
            return this.pos + 1;
        }

        public SequenceIterator getAnother() {
            return new CharacterIterator();
        }
    }
}

