/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2020 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/
#include "SDL_config.h"

#include "SDL_test.h"

/* GIMP RGB C-Source image dump (alpha.c) */

static const SDLTest_SurfaceImage_t SDLTest_imagePrimitivesBlend = {
  80, 60, 3,
  "\260e\15\222\356/\37\313\15\36\330\17K\3745D\3471\0\20\0D\3502D\3502<\321"
  ",\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\0-\0\377\377"
  "\377\377\377\377\311\324\311\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\0H\0\377\377\377\377\377\377\256\307\256\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\0c\0\377\377\377\377\377\377"
  "\223\300\223\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\0~\0\377\377\377\377\377\377x\277x\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\0\231\0\377\377\377\377\377\377]\303]\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\0\264\0\377\377\377\377\377"
  "\377B\316B\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\0"
  "\317\0\377\377\377\377\377\377'\335'\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\0\352\0\377\377\377#\262\6\260d\15\260e\15\224\357"
  "/&\262\6\34\300\5.\314\22\40\315\12[\3747M\332/\27\331\12\27\331\12K\374"
  "5K\3745K\3745D\3471D\3471D\3471D\3471D\3471D\3502D\3502D\3502D\3502D\350"
  "2D\3502D\3502D\3502D\3502D\3502\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377,\372\27\273\3465\327"
  "Q.\260d\15\213\213\40\241\3601\200\366*=\265\13?\301\25s\375<Y\316-X\320"
  "-!\315\13]\3749]\3749O\3321O\3321P\3342P\3342P\3342\371\377\364\371\377\364"
  "\371\377\364\371\377\364\371\377\364\362\375\360\362\375\360\362\375\360"
  "\362\375\360\362\375\360D\3471D\3471D\3471D\3502D\3502D\3502D\3502D\3502"
  "D\3502D\3502D\3502D\3502D\3502D\3502D\3502D\3502D\3502D\3502D\3502D\3502"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "K\3745&\262\6\213\213\40\11\2\0\260`\15\241~#m}\11\273\363AQ\247\15S\266"
  "\31\212\373@e\302,\4\33\2s\375<\\\3161M\260*\\\3202X\320-\366\377\354\364"
  "\377\352O\3321\3""5\2O\3321O\3321<\261&P\3342P\3342S\3655\377\377\377\377"
  "\377\377\14Z\14\377\377\377\377\377\377\234\302\231\371\377\364\362\375\360"
  "\367\377\365\362\375\360\362\375\360\13t\13\362\375\360\362\375\360\177\275"
  "~\362\375\360\362\375\360\370\377\366\362\375\360\377\377\377\14\220\14\377"
  "\377\377D\3502\"\267\33D\3502D\3502K\3779D\3502D\3502\3\233\2D\3502D\350"
  "2\34\303\26D\3502D\3502L\377:D\3502D\3502\3\264\2D\3502D\3502\25\323\22\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\14\341\14\377\377"
  "\377\377\377\377\40\353\40\377\377\377D\3471\34\300\5e\247\33\356\336?\277"
  "f)\260P\17\260i\16\356\336?\331\353C\274\363GQ\247\15\243\370Cp\270)\212"
  "\373@h\3021h\3042c\304+\364\377\336\\\3161\\\3161\\\3202\\\3202\\\3202\377"
  "\377\377\364\377\352\364\377\352\346\371\342\346\371\342O\3321O\3321P\334"
  "2P\3342P\3342P\3342P\3342P\3342\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\362\375\360\362\375\360\362\375\360\362\375\360\362\375"
  "\360\362\375\360\362\375\360\362\375\360\362\375\360\362\375\360\362\375"
  "\360\362\375\360\362\375\360\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377D\3502D\3502D\3502D\3502D\3502D\3502D\3502D\3502D\3502D\3502D\3502\40"
  "\315\12=\265\13f\230\14\237y\15\274Y\17\327Q.\260X\14\243\177$\220\214\""
  "\215\235*\274\363G\177\252+\243\370Cu\2661p\270)\367\377\324h\3021h\3021"
  "h\3042\364\377\336\364\377\336\335\364\323\\\3161\\\3161\\\3202\\\3202\\"
  "\3202\377\377\377\377\377\377\364\377\352\364\377\352\346\371\342\346\371"
  "\342\346\371\342\346\371\342O\3321P\3342P\3342P\3342P\3342P\3342P\3342P\334"
  "2\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\362\375\360\362\375\360"
  "\362\375\360\362\375\360\362\375\360\362\375\360\362\375\360\362\375\360"
  "\362\375\360\362\375\360\362\375\360\362\375\360\362\375\360\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\6\0\4[\3747?\301\25N\241\14\331\353C\243\177$\275Z\21\377\254W\260Q\17\30"
  "\26\7\370\343N\201\210\16|\213-\274\363G\200\2521\202\263+\243\370Cu\266"
  "1\12&\4\367\377\324h\3021S\241)h\3042h\3042\377\377\377\364\377\336\335\364"
  "\323\24M\23\\\3161\\\3202C\245(\\\3202\\\3202\377\377\377\377\377\377\377"
  "\377\377\30l\30\346\371\342\346\371\342\207\273\205\346\371\342\346\371\342"
  "\361\377\355\377\377\377P\3342\7t\4P\3342P\3342/\260\"P\3342P\3342^\377@"
  "\377\377\377\377\377\377\30\242\30\377\377\377\377\377\377d\306d\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\30\275\30\377\377\377"
  "\377\377\377K\322K\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\30\330\30\362\375\360\362\375\3601\3431\362\375\360\362\375\360\377"
  "\377\377\362\375\360D\3502M\332/s\375<>\265\14\177\252+\201\210\16\245\204"
  "*\377\314U\312\\,\224'\11\260i\17\244\210\40\232\2211\331\353J\215\2351\377"
  "\377\276\200\2521\200\2542\375\377\310u\2661t\2702t\2702\367\377\324\325"
  "\355\305h\3021h\3042h\3042\377\377\377\377\377\377\364\377\336\335\364\323"
  "\335\364\323\335\364\323\\\3202\\\3202\\\3202\\\3202\\\3202\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\346\371\342\346\371\342\346"
  "\371\342\346\371\342\346\371\342\346\371\342\346\371\342\377\377\377\377"
  "\377\377P\3342P\3342P\3342P\3342P\3342P\3342P\3342P\3342\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\27\331\12Y\316-h\3021\243\370Cg\230\15\230\224\"\245"
  "\204*\377\314U\310J\21\327Q.\260b\21\245\2041\370\343N\230\2242\331\353J"
  "\214\2402\377\377\276\200\2521\200\2542\375\377\310\317\344\266u\2661t\270"
  "2\377\377\377\367\377\324\325\355\305h\3021h\3042h\3042h\3042\377\377\377"
  "\377\377\377\364\377\336\335\364\323\335\364\323\335\364\323\335\364\323"
  "\\\3202\\\3202\\\3202\\\3202\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\346\371\342\346\371"
  "\342\346\371\342\346\371\342\346\371\342\346\371\342\377\377\377\377\377"
  "\377\377\377\377\377\377\377P\3342P\3342P\3342P\3342P\3342P\3342P\3342P\334"
  "2\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377K\3745!\315\13d\304,p\270)\177\252+\23\13\6\232\2211\245\204"
  "1\347\270O\377\277Y\324<\22\265V\24\377\330Q\244\210\40#(\13\230\224\"\331"
  "\353Ju\211.\377\377\276\200\2521\210\273:\200\2542\375\377\310\20""3\6u\266"
  "1t\2702\271\307\271\367\377\324\325\355\305\341\377\321h\3021h\3042\16L\7"
  "h\3042\377\377\377\242\300\242\377\377\377\335\364\323\355\377\343\335\364"
  "\323\335\364\323\14f\7\\\3202\\\3202>\250*\\\3202\377\377\377\377\377\377"
  "\377\377\377\377\377\377$\231$\377\377\377\377\377\377s\303s\377\377\377"
  "\346\371\342\376\377\372\346\371\342\346\371\342\40\257\37\346\371\342\346"
  "\371\342\\\316\\\377\377\377\377\377\377\377\377\377\377\377\377P\3342\13"
  "\262\7P\3342P\3342*\327%P\3342P\3342o\377Q\377\377\377\377\377\377$\352$"
  "\377\377\377\377\377\377K\3745]\3749s\375<\212\373@\243\370C\274\363G\331"
  "\353J\370\343N\377\330Q\377\314U\377\277Y\377\260\\\224(\11\260|\36\245\204"
  "1\377\377\250\232\2211\230\224\"\215\2351\214\2402\377\377\276\312\332\250"
  "\200\2521\200\2542\377\377\377\317\344\266u\2661t\2702t\2702\377\377\377"
  "\377\377\377\325\355\305\325\355\305\325\355\305h\3042h\3042h\3042\377\377"
  "\377\377\377\377\377\377\377\377\377\377\335\364\323\335\364\323\335\364"
  "\323\335\364\323\335\364\323\\\3202\\\3202\\\3202\\\3202\\\3202\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\346\371\342\346\371\342"
  "\346\371\342\346\371\342\346\371\342\346\371\342\346\371\342\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377P\3342P\3342"
  "P\3342P\3342\377\377\377K\3745O\3321\\\3161h\3021t\2702~\254'\214\240%\377"
  "\377\262\370\343N\377\330Q\262x1\277l1\312`1\327R.\260X\23\377\330Q\244\210"
  "2\377\377\250\230\2242\377\377\262\215\2351\214\2402\377\377\377\312\332"
  "\250\200\2521\200\2542\377\377\377\375\377\310\317\344\266u\2661t\2702t\270"
  "2\377\377\377\377\377\377\325\355\305\325\355\305\325\355\305h\3042h\304"
  "2h\3042h\3042\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\335\364\323\335\364\323\335\364\323\335\364\323\377\377\377\\\3202\\\320"
  "2\\\3202\\\3202\\\3202\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\346\371\342\346\371\342\346\371\342\346"
  "\371\342\346\371\342\346\371\342\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377D\3471O\3321\21\7\11c\304+\367\377\324o\2520\200\252"
  "1\214\2402\235\226'\377\377\250\377\330Q!\20\11\277l1\310d2\266?\33\224("
  "\11\260|\36\257\217;\377\377\250\232\2211\34$\11\377\377\262\215\2351q\206"
  "0\377\377\377\312\332\250\217\303@\200\2542\200\25420Z0\317\344\266\317\344"
  "\266X\2260t\2702t\2702\377\377\377\377\377\377\325\355\305(l%\325\355\305"
  "\325\355\305K\2410h\3042h\3042\377\377\377\377\377\377\377\377\3770\2200"
  "\377\377\377\377\377\377t\274p\335\364\323\335\364\323\373\377\361\377\377"
  "\377\377\377\377\21\213\11\\\3202\\\3202<\274/\\\3202\377\377\377\377\377"
  "\377\377\377\377\377\377\3770\3060\377\377\377\377\377\377V\330V\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\3770\3410\346\371\342\346"
  "\371\342>\352>\346\371\342\377\377\377D\3471P\3342\364\377\352s\375<h\302"
  "1t\2702~\254'\377\377\276\215\2351\230\2242\244\210\40\377\377\234\262x1"
  "\277l1\310W\32\377\260\\\327T1\260|2\377\330Q\244\2102\377\377\250\232\221"
  "1\230\2242\377\377\262\215\2351\214\2402\377\377\377\377\377\276\312\332"
  "\250\200\2542\200\2542\377\377\377\375\377\310\317\344\266\317\344\266t\270"
  "2t\2702t\2702\377\377\377\377\377\377\377\377\377\325\355\305\325\355\305"
  "\325\355\305h\3042h\3042h\3042h\3042\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\335\364\323\335\364\323\335\364\323"
  "\335\364\323\335\364\323\377\377\377\377\377\377\\\3202\\\3202\\\3202\\\320"
  "2\\\3202\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377D\3471P\3342\364\377\352\\\3161h\3042\367"
  "\377\324u\2661\200\2542\214\240%\377\377\262\232\2211\244\2102\377\377\234"
  "\262x1\274p2\377\337\207\377\260\\\327T1\227/\14\377\377\234\245\2041\244"
  "\2102\307\300\213\230\2242\377\377\377\377\377\262\215\2351\214\2402\377"
  "\377\377\377\377\276\312\332\250\200\2542\200\2542\377\377\377\377\377\377"
  "\317\344\266\317\344\266\317\344\266t\2702t\2702\377\377\377\377\377\377"
  "\377\377\377\377\377\377\325\355\305\325\355\305\325\355\305\377\377\377"
  "h\3042h\3042h\3042h\3042\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\335\364\323\335\364\323\335\364\323"
  "\335\364\323\377\377\377\377\377\377\377\377\377\\\3202\\\3202\\\3202\\\320"
  "2\\\3202\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377<\0<D\3502\371\377\364N\3221\\\3202\364\377"
  "\336l\3035t\2702\375\377\310\36\22\13\214\2402\377\377\262\214\2012\244\210"
  "2\377\377\234\274\177;\274p2\377\337\207/\24\13\324X2\227/\14\222l3\307\260"
  "|\244\2102\377\377\270\232\2211\230\2242<Q<\310\316\231\215\2351o\2065\377"
  "\377\377\377\377\276\341\377\277\200\2521\200\2542\36H\13\377\377\377\377"
  "\377\377\213\260}\317\344\266t\2702\221\366Ot\2702\377\377\377<\207<\377"
  "\377\377\377\377\377}\270v\325\355\305\325\355\305\371\377\351\377\377\377"
  "h\3042\30|\13h\3042\377\377\377|\306|\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377<\275<\335\364\323\335\364\323_\317]\335\364\323"
  "\335\364\323\377\377\377\377\377\377\377\377\377\25\260\13\\\3202\\\3202"
  ">\3369\\\3202\377\377\377\377\377\377\377\377\377\377\377\377D\3502\371\377"
  "\364O\3321\\\3202\364\377\336h\3042\367\377\324u\2661\200\2542\377\377\276"
  "\215\2351\230\2242\307\300\213\244\2102\377\377\234\262x1\274p2\377\337\207"
  "\312`1\324E\30\327T1\260|2\377\377\234\245\2041\244\2102\377\377\250\232"
  "\2211\230\2242\377\377\377\310\316\231\215\2351\214\2402\377\377\377\377"
  "\377\377\312\332\250\312\332\250\200\2542\200\2542\377\377\377\377\377\377"
  "\317\344\266\317\344\266\317\344\266t\2702t\2702t\2702\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\325\355\305\325\355\305\325\355"
  "\305\377\377\377h\3042h\3042h\3042h\3042\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\335\364\323\335\364\323\335\364\323\335\364\323\377\377\377\377\377"
  "\377\377\377\377\377\377\377\\\3202\\\3202\\\3202\377\377\377D\3502\371\377"
  "\364O\3321\377\377\377\\\3161h\3042\367\377\324t\2702\375\377\310\200\252"
  "1\377\377\377\215\2351\230\2242\377\377\250\244\2102\377\377\234\262x1\274"
  "p2\316\214_\310d2\377\310|\327T1\227/\14\377\377\377\307\260|\244\2102\377"
  "\377\377\307\300\213\230\2242\230\2242\377\377\377\310\316\231\214\2402\214"
  "\2402\377\377\377\377\377\377\312\332\250\312\332\250\200\2542\200\2542\377"
  "\377\377\377\377\377\377\377\377\317\344\266\317\344\266\317\344\266t\270"
  "2t\2702t\2702\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\325\355\305\325\355\305\325\355\305\377\377\377\377\377\377h\3042h\3042"
  "h\3042\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\335\364\323\335\364"
  "\323\335\364\323\335\364\323\377\377\377\377\377\377\377\377\377\377\377"
  "\377D\3502\371\377\364R\3344\364\377\352\\\3161H\22Hh\3021\377\377\377o\244"
  "2\200\2542\312\332\250\226\245<\377\377\262\230\2242H-/\245\2041\377\377"
  "\377\233i5\274p2\277l1\331sC\377\310|\324X2*\15\3\260|2\377\377\234\206s"
  "7\244\2102\377\377\250\340\337\244\230\2242\377\377\377Hc2\310\316\231\214"
  "\2402n\211:\377\377\377\377\377\377\353\377\311\312\332\250\200\2542$T\16"
  "\377\377\377\377\377\377\236\277\236\377\377\377\317\344\266\367\377\336"
  "\377\377\377t\2702\40n\16t\2702\377\377\377\212\303\212\377\377\377\377\377"
  "\377\377\377\377\325\355\305\325\355\305<\2477\377\377\377\377\377\377O\276"
  "Ah\3042h\3042\237\377i\377\377\377\377\377\377H\317H\377\377\377\377\377"
  "\377c\335c\377\377\377\377\377\377\377\377\377\377\377\377\335\364\323>\337"
  ";\335\364\323\377\377\377D\3502\362\375\360P\3342\346\371\342\\\3202\364"
  "\377\336h\3042\367\377\324t\2702\375\377\310\200\2542\377\377\276\214\240"
  "2\377\377\262\232\2211\377\377\377\245\2041\377\377\377\262x1\377\377\377"
  "\277l1\310d2\312`1\324X2\327T1\260|2\377\377\377\307\260|\244\2102\377\377"
  "\377\307\300\213\232\2211\230\2242\377\377\377\377\377\262\310\316\231\214"
  "\2402\214\2402\377\377\377\377\377\377\312\332\250\312\332\250\200\2542\200"
  "\2542\200\2542\377\377\377\377\377\377\377\377\377\317\344\266\317\344\266"
  "\317\344\266\377\377\377t\2702t\2702t\2702\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\325\355\305\325\355\305\325\355\305\325\355"
  "\305\377\377\377\377\377\377h\3042h\3042h\3042h\3042\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377D\3502\362\375\360P\3342\346\371\342\\\3202\335"
  "\364\323h\3042\325\355\305t\2702\317\344\266\377\377\377\200\2521\377\377"
  "\377\215\2351\377\377\377\232\2211\377\377\377\245\2041\377\377\377\262x"
  "1\377\377\377\277l1\377\377\377\312`1\377\310|\327T1\227/\14\377\377\377"
  "\307\260|\244\2102\244\2102\377\377\377\307\300\213\230\2242\230\2242\377"
  "\377\377\310\316\231\310\316\231\214\2402\214\2402\377\377\377\377\377\377"
  "\312\332\250\312\332\250\377\377\377\200\2542\200\2542\377\377\377\377\377"
  "\377\377\377\377\377\377\377\317\344\266\317\344\266\377\377\377\377\377"
  "\377t\2702t\2702\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\325\355\305\325\355\305\325\355\305\377\377"
  "\377\377\377\377\377\377\377h\3042h\3042h\3042\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377D\3502\362\375\360"
  "T\11TO\3321\377\377\377Z\3002\377\377\377h\3042\377\377\334t\2702\375\377"
  "\310*\30\20\312\332\250\214\2402\262\260\214\230\2242\307\300\213\377\377"
  "\377\245\2041\377\377\377:\35\20\377\377\377\277l1\316\264w\310d2\377\310"
  "|\356qL\227/\14\260|2TZ3\307\260|\244\2102\274\302\274\307\300\213\307\300"
  "\213\273\301U\377\377\377\377\377\377A^2\310\316\231\214\2402o\216B\377\377"
  "\377\377\377\377\366\377\324\312\332\250\312\332\250*a\20\200\2542\377\377"
  "\377\230\301\230\377\377\377\377\377\377\377\377\353\317\344\266\317\344"
  "\266T\253Tt\2702t\2702]\265I\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377T\306T\377\377\377\325\355\305l\324i\325\355\305\377\377"
  "\377\377\377\377\377\377\377h\3042\"\254\20h\3042h\3042b\353b\377\377\377"
  "\377\377\377D\3502\362\375\360\377\377\377O\3321\377\377\377\\\3202\364\377"
  "\336h\3042\325\355\305t\2702\317\344\266\377\377\377\200\2521\377\377\377"
  "\214\2402\377\377\262\230\2242\307\300\213\244\2102\307\260|\377\377\377"
  "\262x1\377\377\377\274p2\377\337\207\310d2\377\310|\324X2\333bB\260|2\377"
  "\377\377\307\260|\244\2102\244\2102\377\377\377\307\300\213\232\2211\230"
  "\2242\377\377\377\377\377\377\310\316\231\310\316\231\214\2402\214\2402\377"
  "\377\377\377\377\377\377\377\377\312\332\250\312\332\250\200\2542\200\254"
  "2\200\2542\377\377\377\377\377\377\377\377\377\377\377\377\317\344\266\317"
  "\344\266\317\344\266\377\377\377t\2702t\2702t\2702\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\325\355\305"
  "\325\355\305\325\355\305\325\355\305\377\377\377\377\377\377\377\377\377"
  "h\3042h\3042\377\377\377\377\377\377D\3471\377\377\377P\3342\364\377\352"
  "\\\3202\335\364\323\377\377\377h\3021\377\377\377t\2702\375\377\310\200\254"
  "2\312\332\250\377\377\377\215\2351\377\377\377\230\2242\377\377\250\244\210"
  "2\307\260|\377\377\377\262x1\377\377\377\274p2\377\337\207\310d2\323xQ\324"
  "X2\327T1\227/\14\260|2\377\377\234\307\260|\244\2102\377\377\377\377\377"
  "\377\307\300\213\230\2242\230\2242\377\377\377\377\377\377\310\316\231\310"
  "\316\231\214\2402\214\2402\377\377\377\377\377\377\377\377\377\312\332\250"
  "\312\332\250\377\377\377\200\2542\200\2542\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\317\344\266\317\344\266\377\377\377\377\377"
  "\377t\2702t\2702t\2702\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\325\355\305\325\355\305\325"
  "\355\305\377\377\377\377\377\377`\0`\377\377\377D\3471\371\366\371P\3342"
  "\346\371\342\377\377\377\\\3161\377\377\377'\24\22\325\355\305t\2702\276"
  "\310\251\377\377\377\200\2542\377\377\316\214\2402\310\316\231`6`\230\224"
  "2\377\377\250\222u<\307\260|\377\377\377\315\214L\377\377\377\274p2M,#\310"
  "d2\312`1\306\304\306\324X2\333bB\325\242W\377\377\377\307\260|=9\22\244\210"
  "2\377\377\377\227\234w\307\300\213\230\2242\307\322a\377\377\377\377\377"
  "\377Km9\310\316\231\214\2402r\226K\377\377\377\377\377\377\377\377\377\312"
  "\332\250\312\332\250`\242`\200\2542\200\2542\224\306\224\377\377\377\377"
  "\377\377\377\377\377\377\377\377\317\344\266M\250D\317\344\266\377\377\377"
  "\203\322\203t\2702t\2702\301\377\177\377\377\377\377\377\377`\330`\377\377"
  "\377\377\377\377r\344r\377\377\377\377\377\377\377\377\377\325\355\305\377"
  "\377\377\377\377\377D\3502\371\377\364P\3342\346\371\342\377\377\377\\\320"
  "2\364\377\336h\3042\325\355\305\377\377\377t\2702\317\344\266\200\2542\312"
  "\332\250\377\377\377\214\2402\310\316\231\230\2242\307\300\213\377\377\377"
  "\244\2102\307\260|\377\377\377\200U0\220^\377\7\4/\227U[\246]\377\255Q1\377"
  "\242y\10\3/\306M@\6\4/{^\377mVvmVv\6\5/h\\\377h\\\377\\U\204\12\12\360\5"
  "\5/VX\377VX\377\12\12\360LR\221\12\12\360\5\6/\214\2402\377\377\377\377\377"
  "\377\377\377\377\312\332\250\312\332\250\377\377\377\200\2542\200\2542\200"
  "\2542\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\317\344"
  "\266\317\344\266\317\344\266\377\377\377\377\377\377t\2702t\2702\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377D\3502\362\375\360P\3342\346\371"
  "\342\377\377\377\\\3202\335\364\323\377\377\377h\3042\367\377\324t\2702\317"
  "\344\266\377\377\377\200\2542\312\332\250\377\377\377\214\2402\377\377\262"
  "\230\2242\307\300\213\377\377\377\244\2102\307\260|{^\377\200U0\220^\377"
  "\7\4/\227U[\246]\377\7\3/\377\242y\236\37""2\306M0\210%\14T-2{^\377mVv\6"
  "\5/\6\5/h\\\377\\U\204\\U\204\5\5/\5\5/VX\377VX\377LR\221LR\221\377\377\377"
  "\214\2402\214\2402\377\377\377\377\377\377\377\377\377\312\332\250\312\332"
  "\250\312\332\250\377\377\377\200\2542\200\2542\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\317\344\266\317\344\266\377"
  "\377\377\377\377\377t\2702t\2702t\2702\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377D\3502\365\375\363\377\377"
  "\377O\3321l\22l\\\3202\335\364\323\357\346\357h\3042\325\355\305\377\377"
  "\377t\2702\317\344\266l-l\200\2521\377\377\377\204\211=\310\316\231\377\377"
  "\377\262\243L\307\300\213\377\377\377E&\25mVv{^\377ySB\220^\377\7\4/\275"
  "t\201\246]\377\7\3/I\37!\277Z\377\10\3/\237YQ\6\4/{^\377\236\213\247mVv\6"
  "\5/,-lh\\\377\\U\204dow\5\5/\5\5/\222\251\377VX\377\310\316\231T{@\377\377"
  "\377\214\2402w\240V\377\377\377\377\377\377\377\377\377\377\377\377\312\332"
  "\250U\231G\377\377\377\200\2542q\270\\\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377l\317l\317\344\266\317\344\266z\330v\377\377\377"
  "\377\377\377\323\377\221t\2702t\2702l\352l\377\377\377\377\377\377\377\377"
  "\377D\3502\362\375\360\377\377\377P\3342\346\371\342\377\377\377\\\3202\364"
  "\377\336h\3042\325\355\305\377\377\377t\2702\317\344\266\377\377\377\200"
  "\2542\312\332\250\377\377\377\214\2402\310\316\231\377\377\377\230\2242\307"
  "\300\213\377\377\377\6\5/mVv{^\377\200U0\220^\377\7\4/\227U[\246]\377\7\3"
  "/\255RN\277Z\377\10\3/\306M@\6\4/{^\377{^\377mVv\6\5/\6\5/h\\\377h\\\377"
  "\\U\204\12\12\360\5\5/\12\12\360\377\377\377\377\377\377\310\316\231\310"
  "\316\231\377\377\377\214\2402\214\2402\377\377\377\377\377\377\377\377\377"
  "\377\377\377\312\332\250\312\332\250\377\377\377\200\2542\200\2542\200\254"
  "2\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\317\344\266\317\344\266\317\344\266\377\377\377\377\377\377t\2702t\2702"
  "\377\377\377\377\377\377D\3502\362\375\360\377\377\377P\3342\346\371\342"
  "\377\377\377\\\3202\335\364\323\377\377\377h\3042\325\355\305\377\377\377"
  "t\2702\317\344\266\377\377\377\200\2542\312\332\250\377\377\377\214\2402"
  "\310\316\231\377\377\377\230\2242\307\300\213h\\\377\6\5/mVv{^\377\200U0"
  "\220^\377\7\4/\227U[\246]\377\7\3/\255RN\277Z\377\10\3/\306M@\6\4/\6\4/{"
  "^\377mVvmVv\6\5/\12\12\360h\\\377\\U\204\\U\204\5\5/\230\2242\377\377\377"
  "\377\377\377\377\377\377\310\316\231\310\316\231\377\377\377\214\2402\214"
  "\2402\377\377\377\377\377\377\377\377\377\377\377\377\312\332\250\312\332"
  "\250\377\377\377\377\377\377\200\2542\200\2542\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\317\344\266\317"
  "\344\266\377\377\377\377\377\377\377\377\377\377\377\377D\3502q\10p\377\377"
  "\377P\3342\335\350\332\377\377\377\\\3202\351\366\337\377\377\377h\3042d"
  "!\\\377\377\377t\2702\277\302\252\377\377\377\200\2542\343\345\301\377\377"
  "\377\214\2402^2H\377\377\377\230\2242\257\235\204h\\\377\6\5/\223o\234{^"
  "\377\6\4/<\36""1\377\252\215j)2\211XK\377\250\203\202$2\337~c\377\242y\236"
  "\37""2]#\26\306M@\6\4/ym\274{^\377mVvELn\6\5/h\\\37703x\\U\204\307\300\213"
  "\204\226\\\230\2242\377\377\377\377\377\377\377\377\377\310\316\231^\212"
  "H\377\377\377\214\2402}\256b\377\377\377\377\377\377\377\377\377\377\377"
  "\377\312\332\250_\251O\377\377\377\377\377\377y\310j\200\2542\377\377\377"
  "\377\377\377\377\377\377\377\377\377x\341x\377\377\377\377\377\377\177\350"
  "|\317\344\266\377\377\377\377\377\377D\3502\362\375\360\377\377\377P\334"
  "2\346\371\342\377\377\377\\\3202\335\364\323\377\377\377\377\377\377h\304"
  "2\325\355\305\377\377\377t\2702\317\344\266\377\377\377\200\2542\312\332"
  "\250\377\377\377\214\2402\310\316\231\377\377\377\230\2242\\U\204h\\\377"
  "\6\5/mVv{^\377\6\4/\12\12\360\201Vi\220^\377\7\4/\227U[\246]\377\7\3/\255"
  "RN\277Z\377\10\3/\306M@\6\4/\12\12\360{^\377mVvmVv\6\5/\12\12\360h\\\377"
  "\377\377\377\307\300\213\377\377\377\230\2242\230\2242\377\377\377\377\377"
  "\377\377\377\377\310\316\231\310\316\231\377\377\377\214\2402\214\2402\377"
  "\377\377\377\377\377\377\377\377\377\377\377\312\332\250\312\332\250\312"
  "\332\250\377\377\377\200\2542\200\2542\200\2542\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377D\350"
  "2\362\375\360\377\377\377P\3342\377\377\377\346\371\342\377\377\377\\\320"
  "2\335\364\323\377\377\377h\3042\325\355\305\377\377\377t\2702\317\344\266"
  "\377\377\377\200\2542\377\377\377\312\332\250\377\377\377\214\2402\310\316"
  "\231\377\377\377\5\5/\\U\204h\\\377\6\5/mVv{^\377\6\4/\12\12\360\201Vi\220"
  "^\377\7\4/\227U[\246]\377\7\3/\255RN\277Z\377\10\3/\306M@\6\4/\6\4/{^\377"
  "\12\12\360mVv\6\5/\6\5/\377\377\377\377\377\377\307\300\213\307\300\213\377"
  "\377\377\230\2242\377\377\377\377\377\377\377\377\377\377\377\377\310\316"
  "\231\310\316\231\377\377\377\214\2402\214\2402\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\312\332\250\312\332\250\377\377\377\377"
  "\377\377\200\2542\200\2542\377\377\377\377\377\377\377\377\377\377\377\377"
  "\204\0\204\377\377\377D\3502\355\364\353\377\377\377\377\377\377Y\335;\346"
  "\371\342\377\377\377/\26\31\335\364\323\377\377\377k\255<\325\355\305\377"
  "\377\377\377\377\377t\2702\317\344\266\2046\204\200\2542\312\332\250\340"
  "\317\340\214\2402\310\316\231\377\377\377VX\377\5\5//\33Dh\\\377\6\5/tVz"
  "{^\377\6\4/=0\377\201Vi\220^\377\3\1\30\227U[\246]\377?6U\255RN\277Z\377"
  "\337]s\306M0\306M@\3\2\30{^\377{^\377yv}mVv\244\2102\377\377\377\377\377"
  "\377\377\377\377gyG\307\300\213\230\2242\212\242h\377\377\377\377\377\377"
  "\377\377\377\377\377\377\310\316\231g\230O\377\377\377\214\2402\205\274q"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377h\270V\312\332"
  "\250\377\377\377\222\344\222\200\2542\200\2542\377\377\377\377\377\377\377"
  "\377\377\377\377\377D\3502\362\375\360\377\377\377\377\377\377P\3342\346"
  "\371\342\377\377\377\\\3202\335\364\323\377\377\377\377\377\377h\3042\325"
  "\355\305\377\377\377t\2702\317\344\266\377\377\377\377\377\377\200\2542\312"
  "\332\250\377\377\377\214\2402\310\316\231VX\377\12\12\360\5\5/\\U\204h\\"
  "\377\6\5/mVv{^\377\6\4/\12\12\360\201Vi\220^\377\7\4/\227U[\246]\377\7\3"
  "/\255RN\255RN\277Z\377\10\3/\306M@\6\4/\12\12\360{^\377\12\12\360\307\260"
  "|\244\2102\244\2102\377\377\377\377\377\377\377\377\377\307\300\213\377\377"
  "\377\230\2242\230\2242\377\377\377\377\377\377\377\377\377\377\377\377\310"
  "\316\231\377\377\377\377\377\377\214\2402\214\2402\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\312\332\250\312\332\250\377\377\377"
  "\377\377\377\200\2542\200\2542\377\377\377\377\377\377D\3502\377\377\377"
  "\362\375\360\377\377\377P\3342\346\371\342\377\377\377\\\3202\377\377\377"
  "\335\364\323\377\377\377h\3042\325\355\305\377\377\377\377\377\377t\2702"
  "\317\344\266\377\377\377\200\2542\312\332\250\377\377\377\377\377\377\214"
  "\2402LR\221VX\377\5\5/\\U\204\12\12\360h\\\377\6\5/mVv{^\377\6\4/\12\12\360"
  "\201Vi\220^\377\7\4/\227U[\246]\377\7\3/\7\3/\255RN\277Z\377\10\3/\306M@"
  "\6\4/\6\4/{^\377\377\377\377\307\260|\377\377\377\244\2102\377\377\377\377"
  "\377\377\377\377\377\307\300\213\307\300\213\377\377\377\230\2242\377\377"
  "\377\377\377\377\377\377\377\377\377\377\310\316\231\310\316\231\377\377"
  "\377\377\377\377\214\2402\214\2402\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\312\332\250\312\332\250\377\377\377\377\377\377\377"
  "\377\377\377\377\377D\3502\377\377\377\362\375\360\377\377\377-\17\34\346"
  "\371\342\377\377\377\363\346\363\\\3202\335\364\323\377\377\377h\3042\377"
  "\377\377x)o\377\377\377t\2702\301\276\255\377\377\377\377\377\377\243\273"
  "U\312\332\250\377\377\377O-\34\12\12\360LR\221gU\333\5\5/\\U\204<)\377h\\"
  "\377\6\5/=!B{^\377\6\4/A2\306\201Vi\220^\377I9q\227U[\246]\377]-\220\7\3"
  "/\255RN\245q\304\10\3/\306M0\377\236\221\6\4/\377\377\377\220\231\220\307"
  "\260|\307\260|\226\227m\244\2102\377\377\377\377\377\377\377\377\377\307"
  "\300\213p\207N\230\2242\230\2242\254\316\254\377\377\377\377\377\377\377"
  "\377\377\310\316\231\310\316\231\220\317\220\377\377\377\214\2402\216\316"
  "\200\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377r\310^\312"
  "\332\250\377\377\377\377\377\377\377\377\377D\3502\362\375\360\377\377\377"
  "P\3342\377\377\377\346\371\342\377\377\377\\\3202\335\364\323\377\377\377"
  "\377\377\377h\3042\325\355\305\377\377\377\377\377\377t\2702\317\344\266"
  "\377\377\377\200\2542\377\377\377\312\332\250\377\377\377\5\6/LR\221\12\12"
  "\360VX\377\5\5/\\U\204h\\\377\12\12\360\6\5/mVv{^\377\6\4/\12\12\360\201"
  "Vi\220^\377\7\4/\227U[\12\12\360\246]\377\7\3/\255RN\277Z\377\277Z\377\10"
  "\3/\306M@\260|2\260|2\377\377\377\377\377\377\307\260|\377\377\377\244\210"
  "2\377\377\377\377\377\377\377\377\377\377\377\377\307\300\213\377\377\377"
  "\230\2242\230\2242\377\377\377\377\377\377\377\377\377\377\377\377\310\316"
  "\231\310\316\231\377\377\377\377\377\377\214\2402\214\2402\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377D\3502\362\375\360\377\377\377P\3342\377\377\377\346\371\342\377"
  "\377\377\\\3202\377\377\377\335\364\323\377\377\377h\3042\325\355\305\377"
  "\377\377\377\377\377t\2702\317\344\266\377\377\377\377\377\377\200\2542\312"
  "\332\250\377\377\377\12\12\360\5\6/LR\221VX\377\12\12\360\5\5/\\U\204h\\"
  "\377\6\5/\12\12\360mVv{^\377\6\4/\12\12\360\201Vi\220^\377\7\4/\227U[\227"
  "U[\246]\377\7\3/\255RN\12\12\360\277Z\377\10\3/\333bB\377\377\377\260|2\377"
  "\377\377\377\377\377\307\260|\307\260|\244\2102\244\2102\377\377\377\377"
  "\377\377\377\377\377\307\300\213\307\300\213\377\377\377\230\2242\230\224"
  "2\377\377\377\377\377\377\377\377\377\377\377\377\310\316\231\310\316\231"
  "\377\377\377\377\377\377\214\2402\214\2402\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377)\10\36\362\375\360\377\377\377\370"
  "\356\370P\3342\346\371\342\377\377\377\377\377\377\\\3202\207\"\201\377\377"
  "\377\377\377\377p\250D\325\355\305\377\377\377\377\377\377t\2702\317\344"
  "\266\234?\234\200\2542\377\377\377\274\260\244FS\377\5\6/;#\377LR\221VX\377"
  "\3\1\34\12\12\360\\U\204{^\330\6\5/\12\12\360\257\203\270{^\377\6\4/\6\4"
  "\222\201Vi\220^\377P@d\12\12\360\227U[\370\244\377\7\3/\255RNi./\277Z\377"
  "\324X2\264\202w\333bB\260|2\377\377\377\377\377\377\377\377\377yvK\377\377"
  "\377\244\2102\236\247|\377\377\377\377\377\377\377\377\377\307\300\213\307"
  "\300\213\234\306\234\230\2242\377\377\377\256\330\256\377\377\377\377\377"
  "\377\377\377\377\310\316\231\310\316\231\234\341\234\377\377\377\214\240"
  "2\232\343\223\377\377\377\377\377\377\377\377\377\377\377\377D\3502\362\375"
  "\360\377\377\377\377\377\377P\3342\346\371\342\377\377\377\377\377\377\\"
  "\3202\335\364\323\377\377\377\377\377\377h\3042\325\355\305\377\377\377\377"
  "\377\377t\2702\317\344\266\377\377\377\377\377\377\200\2542\312\332\250\12"
  "\12\360FS\377\5\6/LR\221\12\12\360RW\255\3\5\35\6\11\224ZT\\d[\261\3\4\35"
  "\6\11\224lVTw]\264\4\4\35\6\11\224\200VN\214]\270\4\3\35\6\11\224\226UG\242"
  "\\\274\4\3\35\4\3\35\254R@\377\377\311\203U\36\203U\36\323a:my\36my\36\377"
  "\377\276\377\377\276\243\255X\243\255X\236\371\236e\204\36\236\371\236\374"
  "\377\273\236\371\236\236\371\236\234\275`\236\371\236^\220\36^\220\36\236"
  "\371\236\352\377\267\352\377\267\236\371\236\236\371\236\310\316\231\310"
  "\316\231\377\377\377\377\377\377\214\2402\377\377\377\377\377\377\377\377"
  "\377D\3502\362\375\360\377\377\377\377\377\377P\3342\346\371\342\377\377"
  "\377\377\377\377\\\3202\377\377\377\335\364\323\377\377\377h\3042\377\377"
  "\377\325\355\305\377\377\377t\2702\377\377\377\317\344\266\377\377\377\377"
  "\377\377\200\2542<L\237FS\377\12\12\360\5\6/LR\221\6\11\224RW\255\3\5\35"
  "ZT\\\6\11\224d[\261\3\4\35\6\11\224lVTw]\264\4\4\35\6\11\224\200VN\214]\270"
  "\4\3\35\4\3\35\226UG\242\\\274\6\11\224\4\3\35\304wB\377\377\311\377\377"
  "\311\203U\36\323a:\236\371\236my\36\236\371\236\377\377\276\236\371\236\243"
  "\255X\236\371\236e\204\36e\204\36\374\377\273\374\377\273\236\371\236\234"
  "\275`\234\275`\236\371\236^\220\36^\220\36\236\371\236\352\377\267\352\377"
  "\267\377\377\377\377\377\377\310\316\231\310\316\231\377\377\377\250\0\250"
  "\377\377\377\377\377\377F\3375\362\375\360\377\377\377\377\377\377P\3342"
  "\377\377\377\227\32\224\377\377\377\\\3202\362\340\362\335\364\323\377\377"
  "\377\377\377\377h\3042\325\355\305\2506\250\377\377\377t\2702\304\272\262"
  "\377\377\377\377\377\377\257\300a\12\12\360<L\237.\32\250\5\6/\12\12\360"
  "jSzRW\255\6\11\224D+^ZT\\\6\11\224A&t\3\4\35lVTP9\235w]\264\4\4\35YG\347"
  "\200VN\214]\270\3\4a\4\3\35\226UG\244y\257\6\11\224{a\36\377\322\246\236"
  "\371\236\377\377\311V6\23\323a:\323a:\223\231y\236\371\236\377\377\276\377"
  "\377\377\243\255X\243\255Xh\270he\204\36\236\371\236\272\322\253\374\377"
  "\273\236\371\236\377\377\350\236\371\236\236\371\236=y\23\236\371\236\236"
  "\371\236\262\344\262\377\377\377\377\377\377\377\377\377\310\316\231\377"
  "\377\377\377\377\377\377\377\377D\3502\362\375\360\377\377\377\377\377\377"
  "P\3342\377\377\377\346\371\342\377\377\377\377\377\377\\\3202\335\364\323"
  "\377\377\377\377\377\377h\3042\325\355\305\377\377\377\377\377\377t\2702"
  "\377\377\377\317\344\266\377\377\377\377\377\377\5\6/<L\237\12\12\360FS\377"
  "\5\6/\6\11\224JQbRW\255\6\11\224\3\5\35ZT\\d[\261\6\11\224\3\4\35lVT\6\11"
  "\224w]\264\4\4\35\6\11\224\200VN\214]\270\6\11\224\4\3\35\226UG\242\\\274"
  "\377\377\306{a\36\304wB\304wB\377\377\311\203U\36\203U\36\323a:my\36my\36"
  "\377\377\276\377\377\276\236\371\236\243\255X\236\371\236e\204\36e\204\36"
  "\236\371\236\374\377\273\236\371\236\234\275`\234\275`\236\371\236^\220\36"
  "^\220\36\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377D\3502\362\375\360\377\377\377\377\377\377"
  "P\3342\377\377\377\346\371\342\377\377\377\377\377\377\\\3202\335\364\323"
  "\377\377\377\377\377\377h\3042\377\377\377\325\355\305\377\377\377\377\377"
  "\377t\2702\317\344\266\377\377\377\377\377\377\5\6/\12\12\360<L\237FS\377"
  "\12\12\360\3\5\35JQb\6\11\224RW\255\3\5\35\6\11\224ZT\\d[\261\6\11\224\3"
  "\4\35lVT\6\11\224w]\264\4\4\35\6\11\224\200VN\214]\270\6\11\224\4\3\35\226"
  "UG\236\371\236\377\377\306{a\36\236\371\236\304wB\377\377\311\236\371\236"
  "\203U\36\323a:\236\371\236my\36\236\371\236\377\377\276\236\371\236\243\255"
  "X\243\255X\236\371\236e\204\36\236\371\236\374\377\273\374\377\273\236\371"
  "\236\234\275`\234\275`\236\371\236\230\2242\230\2242\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377J\3508\377\377\377\362"
  "\375\360\264\22\264\377\377\377P\3342\340\340\335\377\377\377\377\377\377"
  "u\325K\377\377\377\335\364\323\264-\264\377\377\377h\3042\315\305\301\377"
  "\377\377\377\377\377\240\307^\377\377\377\317\344\266\264H\264\12\12\360"
  "\5\6/aL\245\12\12\360FS\377E(\323\3\5\35JQb\4\3hRW\255\3\5\35O2\241ZT\\d"
  "[\261X>\346\3\4\35lVT\4\4hw]\264\4\4\35aK\244\200VN\214]\270kZ\371\4\3\35"
  "\270\212Io\225o\377\377\306{a\36\253\300\253\304wB\377\377\311\377\377\377"
  "\203U\36\323a:\224D(my\36\236\371\236\307\316\266\377\377\276\236\371\236"
  "\377\377\343\236\371\236e\204\36Gk\25\236\371\236\374\377\273\260\334\260"
  "\236\371\236\234\275`\377\377\377\377\377\377\230\2242k\207#\377\377\377"
  "\377\377\377\377\377\377\377\377\377D\3502\377\377\377\362\375\360\377\377"
  "\377\377\377\377P\3342\346\371\342\377\377\377\377\377\377\\\3202\377\377"
  "\377\335\364\323\377\377\377\377\377\377h\3042\377\377\377\325\355\305\377"
  "\377\377\377\377\377t\2702\317\344\266\377\377\3778L\377\12\12\360\5\6/<"
  "L\237\12\12\360BR\252\3\5\35\6\11\224JQbRW\255\6\11\224\3\5\35ZT\\\6\11\224"
  "d[\261\6\11\224\3\4\35lVT\6\11\224w]\264\4\4\35\6\11\224\200VN\214]\270\6"
  "\11\224tm\36\270\212I\270\212I\377\377\306{a\36{a\36\304wB\236\371\236\377"
  "\377\311\203U\36\236\371\236\323a:my\36my\36\236\371\236\377\377\276\236"
  "\371\236\243\255X\243\255X\236\371\236e\204\36\236\371\236\374\377\273\374"
  "\377\273\236\371\236\307\300\213\307\300\213\377\377\377\377\377\377\230"
  "\2242\377\377\377\377\377\377\377\377\377D\3502\377\377\377\362\375\360\377"
  "\377\377\377\377\377P\3342\377\377\377\346\371\342\377\377\377\377\377\377"
  "\\\3202\335\364\323\377\377\377\377\377\377\377\377\377h\3042\325\355\305"
  "\377\377\377\377\377\377t\2702\377\377\377\317\344\2668L\377\12\12\360\5"
  "\6/\12\12\360<L\237BR\252\6\11\224\3\5\35JQb\6\11\224RW\255\6\11\224\3\5"
  "\35ZT\\\6\11\224d[\261\3\4\35\6\11\224lVT\6\11\224w]\264\4\4\35\6\11\224"
  "\200VN\214]\270\236\371\236tm\36\236\371\236\270\212I\377\377\306\236\371"
  "\236{a\36\304wB\236\371\236\377\377\311\203U\36\203U\36\323a:\236\371\236"
  "my\36\236\371\236\377\377\276\377\377\276\236\371\236\243\255X\236\371\236"
  "e\204\36e\204\36\236\371\236\374\377\273\377\377\377\377\377\377\307\300"
  "\213\307\300\213\377\377\377\377\377\377\377\377\377\377\377\3773\10%\377"
  "\377\377\362\375\360\372\356\372\377\377\377P\3342\377\377\377\346\371\342"
  "\377\377\377\300$\300\\\3202\377\377\377\327\317\316\377\377\377\377\377"
  "\377\220\317Z\377\377\377\325\355\305\300?\300\377\377\377t\2702\312\267"
  "\270\12\12\3608L\377F#\377\5\6/<L\237\4\3oBR\252\6\11\224K)[JQb\6\11\224"
  "\243\204\376\3\5\35\6\11\224C&E\6\11\224d[\261_@l\6\11\224lVTkP\371w]\264"
  "\4\4\35\4\5o\200VN\377\377\302\262\276\262tm\36\236\371\236\377\360\302\377"
  "\377\306\236\371\236\\A\26\304wB\304wB\322\312\302\236\371\236\203U\36\377"
  "\355\310\323a:my\36R]\26\236\371\236\377\377\276\270\326\270\243\255X\236"
  "\371\236\377\377\377e\204\36\236\371\236\300\341\300\377\377\377\377\377"
  "\377\305\353\305\307\300\213\377\377\377\377\377\377\377\377\377D\3502\377"
  "\377\377\362\375\360\377\377\377\377\377\377P\3342\377\377\377\346\371\342"
  "\377\377\377\377\377\377\\\3202\377\377\377\335\364\323\377\377\377\377\377"
  "\377h\3042\377\377\377\325\355\305\377\377\377\377\377\377t\2702\377\377"
  "\3770E\254\12\12\3608L\377\5\6/\12\12\360:Lj\6\11\224BR\252\3\5\35\6\11\224"
  "JQb\6\11\224RW\255\3\5\35\6\11\224ZT\\\6\11\224d[\261\3\4\35\6\11\224lVT"
  "\6\11\224w]\264\4\4\35\6\11\224\255\235Q\377\377\302\377\377\302tm\36\236"
  "\371\236\270\212I\377\377\306\377\377\306{a\36\236\371\236\304wB\377\377"
  "\311\377\377\311\203U\36\236\371\236\323a:\236\371\236my\36\236\371\236\377"
  "\377\276\236\371\236\243\255X\243\255X\236\371\236e\204\36\244\2102\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377D\3502\377\377\377\362\375\360\377\377\377\377\377\377P\3342\377\377"
  "\377\346\371\342\377\377\377\377\377\377\377\377\377\\\3202\335\364\323\377"
  "\377\377\377\377\377\377\377\377h\3042\325\355\305\377\377\377\377\377\377"
  "\377\377\377t\2702\317\344\266\377\377\377\377\377\377\377\377\377\200\254"
  "2\236\371\236\222\326p\332\377\264\236\371\236V\234\36\236\371\236\226\312"
  "g\352\377\267\236\371\236^\220\36\236\371\236\234\275`\374\377\273\236\371"
  "\236e\204\36\236\371\236\243\255X\377\377\276\236\371\236my\36\236\371\236"
  "\255\235Q\236\371\236\377\377\302tm\36\236\371\236\270\212I\236\371\236\377"
  "\377\306{a\36\236\371\236\304wB\236\371\236\377\377\311\203U\36\203U\36\323"
  "a:\236\371\236my\36\236\371\236\377\377\276\377\377\276\236\371\236\243\255"
  "X\236\371\236\377\377\377\244\2102\377\377\377\377\377\377\377\377\377\314"
  "\0\314\377\377\377\377\377\377H\3377\377\377\377\362\375\360\377\377\377"
  "\377\377\377\377\377\377@\27(\346\371\342\377\377\377\367\340\367\377\377"
  "\377\\\3202\377\377\377\335\364\323\377\377\377\3146\314h\3042\377\377\377"
  "\322\301\306\377\377\377\377\377\377\255\314k\377\377\377\317\344\266\314"
  "Q\314\377\377\377\200\2542\256\300\256\222\326p\236\371\236\377\377\377\236"
  "\371\236V\234\36xUR\236\371\236\352\377\267\262\273\262^\220\36\234\275`"
  "\377\377\377\374\377\273\236\371\236PE\30\236\371\236\243\255X\342\300\305"
  "\236\371\236my\36\377\377\377\255\235Q\236\371\236\314\242\233tm\36\236\371"
  "\236\304\237\240\236\371\236\377\377\306\377\340\256{a\36\304wB~\270~\377"
  "\377\311\236\371\236\273\254\244\323a:\323a:\377\377\303my\36\236\371\236"
  "\314\330\230\236\371\236\243\255X\313\332\302\377\377\377\244\2102\377\377"
  "\355\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377D\3502\362"
  "\375\360\377\377\377\377\377\377\377\377\377P\3342\377\377\377\346\371\342"
  "\377\377\377\377\377\377\\\3202\377\377\377\335\364\323\377\377\377\377\377"
  "\377h\3042\377\377\377\325\355\305\377\377\377\377\377\377\377\377\377t\270"
  "2\317\344\266\377\377\377\377\377\377\377\377\377O\247\36\236\371\236\222"
  "\326p\332\377\264\236\371\236V\234\36\236\371\236\226\312g\236\371\236\352"
  "\377\267\236\371\236^\220\36\234\275`\236\371\236\374\377\273\236\371\236"
  "e\204\36\236\371\236\243\255X\377\377\276\236\371\236my\36\236\371\236\255"
  "\235Q\236\371\236\377\377\302tm\36\236\371\236\270\212I\236\371\236\377\377"
  "\306\236\371\236{a\36\304wB\304wB\377\377\311\236\371\236\203U\36\236\371"
  "\236\323a:\236\371\236my\36\236\371\236\377\377\276\377\377\276\377\377\377"
  "\307\260|\377\377\377\377\377\377\244\2102\377\377\377\377\377\377\377\377"
  "\377\377\377\377D\3502\362\375\360\377\377\377\377\377\377\377\377\377P\334"
  "2\377\377\377\346\371\342\377\377\377\377\377\377\\\3202\377\377\377\335"
  "\364\323\377\377\377\377\377\377\377\377\377h\3042\377\377\377\325\355\305"
  "\377\377\377\377\377\377t\2702\377\377\377\317\344\266\377\377\377\377\377"
  "\377\236\371\236O\247\36\222\326p\236\371\236\332\377\264\236\371\236V\234"
  "\36\236\371\236\226\312g\236\371\236\352\377\267^\220\36\236\371\236\234"
  "\275`\236\371\236\374\377\273\236\371\236e\204\36\236\371\236\243\255X\377"
  "\377\276\236\371\236my\36\236\371\236\255\235Q\236\371\236\377\377\302tm"
  "\36tm\36\270\212I\236\371\236\377\377\306\236\371\236{a\36\236\371\236\304"
  "wB\377\377\311\377\377\311\203U\36\236\371\236\323a:\236\371\236my\36\236"
  "\371\236\236\371\236\377\377\377\377\377\377\307\260|\307\260|\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377D\3502\362\375\360\330\22"
  "\330\377\377\377\377\377\377]\306B\377\377\377\346\371\342\377\377\377\377"
  "\377\377\377\377\377M$*\335\364\323\377\377\377\366\324\366\377\377\377h"
  "\3042\377\377\377\325\355\305\377\377\377\330H\330\377\377\377t\2702\321"
  "\264\300\377\377\377\377\377\377\352\377\352O\247\36\236\371\236{S^\236\371"
  "\236\332\377\264\266\274\266V\234\36\226\312g\377\377\377\352\377\267\236"
  "\371\236OG\31\236\371\236\234\275`\274\274\274\374\377\273\236\371\236\336"
  "\325\227\243\255X\236\371\236\330\231\240\236\371\236my\36\302\300\302\255"
  "\235Q\236\371\236\377\377\377\236\371\236tm\36\233a=\236\371\236\377\377"
  "\306\310\314\310{a\36\236\371\236\377\377\351\236\371\236\377\377\311nE\31"
  "\203U\36\323a:\326\304\276my\36my\36\377\377\377\377\377\377\377\377\377"
  "\330\352\330\307\260|\377\377\377\377\377\377\377\377\377\377\377\377D\350"
  "2\377\377\377\362\375\360\377\377\377\377\377\377P\3342\377\377\377\346\371"
  "\342\377\377\377\377\377\377\377\377\377\\\3202\377\377\377\335\364\323\377"
  "\377\377\377\377\377\377\377\377h\3042\325\355\305\377\377\377\377\377\377"
  "\377\377\377t\2702\377\377\377\317\344\266\377\377\377\377\377\377\377\377"
  "\377\200\2542\377\377\377\312\332\250\377\377\377\377\377\377\214\2402\377"
  "\377\377\310\316\231\377\377\377\377\377\377\377\377\377\230\2242\377\377"
  "\377\307\300\213\377\377\377\377\377\377\244\2102\377\377\377\307\260|\377"
  "\377\377\377\377\377\377\377\377\260|2\377\377\377\312\237n\377\377\377\377"
  "\377\377\377\377\377\274p2\316\214_\316\214_\377\377\377\377\377\377\310"
  "d2\377\377\377\323xQ\377\377\377\377\377\377\377\377\377\324X2\377\377\377"
  "\333bB\377\377\377\260|2\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377D\3502\377\377\377\362\375"
  "\360\377\377\377\377\377\377P\3342\377\377\377\346\371\342\377\377\377\377"
  "\377\377\377\377\377\\\3202\377\377\377\335\364\323\377\377\377\377\377\377"
  "\377\377\377h\3042\377\377\377\325\355\305\377\377\377\377\377\377\377\377"
  "\377t\2702\317\344\266\377\377\377\377\377\377\377\377\377\200\2542\377\377"
  "\377\312\332\250\377\377\377\377\377\377\377\377\377\214\2402\377\377\377"
  "\310\316\231\377\377\377\377\377\377\377\377\377\230\2242\377\377\377\307"
  "\300\213\377\377\377\377\377\377\244\2102\377\377\377\307\260|\377\377\377"
  "\377\377\377\377\377\377\260|2\377\377\377\312\237n\377\377\377\377\377\377"
  "\377\377\377\274p2\377\377\377\316\214_\377\377\377\377\377\377\310d2\310"
  "d2\323xQ\377\377\377\377\377\377\377\377\377\324X2\377\377\377\333bB\377"
  "\377\377\260|2\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\344\11\344D\3502\377\377\377\360\354\357\377\377\377\377\377"
  "\377\377\377\377P\3342\377\377\377\315#\312\377\377\377\377\377\377s\262"
  "Q\377\377\377\335\364\323\377\377\377\377\377\377\377\377\377\\0,\377\377"
  "\377\325\355\305\367\313\367\377\377\377\377\377\377\274\321z\377\377\377"
  "\317\344\266\344Z\344\377\377\377\377\377\377\246\217v\377\377\377\312\332"
  "\250\377\377\377\377\377\377\377\377\377}I,\377\377\377\310\316\231\361\277"
  "\361\377\377\377\230\2242\377\377\377\307\300\213\377\377\377\344\220\344"
  "\377\377\377\244\2102\356\301\356\307\260|\377\377\377\377\377\377\377\377"
  "\377\260|2\344\253\344\312\237n\377\377\377\353\312\353\377\377\377\274p"
  "2\377\377\377\316\214_\377\377\377\344\306\344\377\377\377\310d2\340\276"
  "\310\323xQ\377\377\377\377\377\377\324X2\324X2\303V;\333bB\260|2\337\340"
  "\325\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377D\3502\377"
  "\377\377\362\375\360\377\377\377\377\377\377\377\377\377P\3342\377\377\377"
  "\346\371\342\377\377\377\377\377\377\377\377\377\\\3202\377\377\377\335\364"
  "\323\377\377\377\377\377\377\377\377\377h\3042\377\377\377\325\355\305\377"
  "\377\377\377\377\377\377\377\377t\2702\317\344\266\377\377\377\377\377\377"
  "\377\377\377\200\2542\377\377\377\312\332\250\377\377\377\377\377\377\377"
  "\377\377\214\2402\377\377\377\310\316\231\377\377\377\377\377\377\377\377"
  "\377\230\2242\377\377\377\307\300\213\377\377\377\377\377\377\377\377\377"
  "\244\2102\377\377\377\307\260|\377\377\377\377\377\377\377\377\377\260|2"
  "\377\377\377\312\237n\377\377\377\377\377\377\377\377\377\274p2\377\377\377"
  "\316\214_\377\377\377\377\377\377\377\377\377\310d2\377\377\377\323xQ\377"
  "\377\377\377\377\377\377\377\377\324X2\377\377\377\333bB\377\377\377\260"
  "|2\377\377\377\377\377\377\377\377\377\377\377\377D\3502\377\377\377\362"
  "\375\360\377\377\377\377\377\377\377\377\377P\3342\377\377\377\346\371\342"
  "\377\377\377\377\377\377\377\377\377\\\3202\377\377\377\335\364\323\377\377"
  "\377\377\377\377\377\377\377h\3042\377\377\377\325\355\305\377\377\377\377"
  "\377\377\377\377\377t\2702\377\377\377\317\344\266\377\377\377\377\377\377"
  "\377\377\377\200\2542\377\377\377\312\332\250\377\377\377\377\377\377\377"
  "\377\377\214\2402\377\377\377\310\316\231\377\377\377\377\377\377\377\377"
  "\377\230\2242\377\377\377\307\300\213\377\377\377\377\377\377\377\377\377"
  "\244\2102\377\377\377\307\260|\377\377\377\377\377\377\377\377\377\260|2"
  "\377\377\377\312\237n\377\377\377\377\377\377\377\377\377\274p2\377\377\377"
  "\316\214_\377\377\377\377\377\377\377\377\377\310d2\377\377\377\323xQ\377"
  "\377\377\377\377\377\377\377\377\324X2\377\377\377\333bB\377\377\377",
};

/**
 * \brief Returns the PrimitivesBlend test image as SDL_Surface.
 */
SDL_Surface *SDLTest_ImagePrimitivesBlend()
{
   SDL_Surface *surface = SDL_CreateRGBSurfaceFrom(
        (void*)SDLTest_imagePrimitivesBlend.pixel_data,
        SDLTest_imagePrimitivesBlend.width,
        SDLTest_imagePrimitivesBlend.height,
        SDLTest_imagePrimitivesBlend.bytes_per_pixel * 8,
        SDLTest_imagePrimitivesBlend.width * SDLTest_imagePrimitivesBlend.bytes_per_pixel,
#if (SDL_BYTEORDER == SDL_BIG_ENDIAN)
         0xff000000, /* Red bit mask. */
         0x00ff0000, /* Green bit mask. */
         0x0000ff00, /* Blue bit mask. */
         0x000000ff  /* Alpha bit mask. */
#else
         0x000000ff, /* Red bit mask. */
         0x0000ff00, /* Green bit mask. */
         0x00ff0000, /* Blue bit mask. */
         0xff000000  /* Alpha bit mask. */
#endif
         );
   return surface;
}

/* vi: set ts=4 sw=4 expandtab: */
