# Artist: Frank Zappa
# Album: Joe's Garage
# Song: Watermelon In Easter Hay

# backing track only

# as this track takes a long time to compile
# I have shortened it here. To get the full
# length to play along to, change `repeat 62'
# in each track to `repeat 24'

@head {
	$tempo 60
	$title "Frank Zappa - Watermelon In Easter Hay"
	$key e
}

@body {

	# backing guitar

	@channel 1 "guitar" {
		$patch 27

		%repeat 24 {
			$time_sig 4/4 /l4/c+5 a4 e g+3
			$time_sig 5/4 /l4/e b f+4 b d+5
		}
	}

	# bass

	@channel 2 "bass" {
		$patch 34
		$volume 127

		%repeat 24 { /l1/a2 /l5:4/e2 }
	}

	# drums

	%define drum_main {
		$length 4

		%repeat 4 { c3 ( c3 d3 ) } c3
	}

	@channel 10 "drums" {
		$reverb 80

		%repeat 24 { ~drum_main }
	}

	# cymbals

	@channel 10 "cymbals" {
		$length 4

		%repeat 24 {
			cym_crash /r2/r
			%choose { 4 cym_crash 2 cym_ride 1 cym_splash 12 r }
			/r2/r
			%repeat 2 { %choose { 2 cym_crash 1 cym_ride 7 r } }
			r
		}
	}

	# hi hat

	@channel 10 "hi hat" {
		$volume 72
		%repeat 24 {
			/l16/r
			%choose 35:16 {
				4 /l16/hh_c
				1 /l8/hh_o
				2 /l8/hh_p
				6 /l16/r
			}
		}
	}
}
