// chrome/browser/ui/webui/plugins/plugins.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chrome/browser/ui/webui/plugins/plugins.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mojom');



  function MimeType(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MimeType.prototype.initDefaults_ = function() {
    this.description = null;
    this.fileExtensions = null;
    this.mimeType = null;
  };
  MimeType.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MimeType.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MimeType.description
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MimeType.fileExtensions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MimeType.mimeType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MimeType.encodedSize = codec.kStructHeaderSize + 24;

  MimeType.decode = function(decoder) {
    var packed;
    var val = new MimeType();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.description = decoder.decodeStruct(codec.String);
    val.fileExtensions = decoder.decodeArrayPointer(codec.String);
    val.mimeType = decoder.decodeStruct(codec.String);
    return val;
  };

  MimeType.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MimeType.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.description);
    encoder.encodeArrayPointer(codec.String, val.fileExtensions);
    encoder.encodeStruct(codec.String, val.mimeType);
  };
  function PluginFile(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginFile.prototype.initDefaults_ = function() {
    this.description = null;
    this.enabledMode = null;
    this.mimeTypes = null;
    this.name = null;
    this.path = null;
    this.type = null;
    this.version = null;
  };
  PluginFile.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginFile.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginFile.description
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginFile.enabledMode
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginFile.mimeTypes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(MimeType), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginFile.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginFile.path
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginFile.type
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginFile.version
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 48, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PluginFile.encodedSize = codec.kStructHeaderSize + 56;

  PluginFile.decode = function(decoder) {
    var packed;
    var val = new PluginFile();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.description = decoder.decodeStruct(codec.String);
    val.enabledMode = decoder.decodeStruct(codec.String);
    val.mimeTypes = decoder.decodeArrayPointer(new codec.PointerTo(MimeType));
    val.name = decoder.decodeStruct(codec.String);
    val.path = decoder.decodeStruct(codec.String);
    val.type = decoder.decodeStruct(codec.String);
    val.version = decoder.decodeStruct(codec.String);
    return val;
  };

  PluginFile.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginFile.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.description);
    encoder.encodeStruct(codec.String, val.enabledMode);
    encoder.encodeArrayPointer(new codec.PointerTo(MimeType), val.mimeTypes);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.path);
    encoder.encodeStruct(codec.String, val.type);
    encoder.encodeStruct(codec.String, val.version);
  };
  function PluginData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginData.prototype.initDefaults_ = function() {
    this.alwaysAllowed = false;
    this.trusted = false;
    this.policyClickToPlay = false;
    this.critical = false;
    this.description = null;
    this.enabledMode = null;
    this.id = null;
    this.name = null;
    this.updateUrl = null;
    this.version = null;
    this.pluginFiles = null;
  };
  PluginData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate PluginData.description
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate PluginData.enabledMode
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginData.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginData.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginData.updateUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginData.version
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 48, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginData.pluginFiles
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, new codec.PointerTo(PluginFile), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PluginData.encodedSize = codec.kStructHeaderSize + 64;

  PluginData.decode = function(decoder) {
    var packed;
    var val = new PluginData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.alwaysAllowed = (packed >> 0) & 1 ? true : false;
    val.trusted = (packed >> 1) & 1 ? true : false;
    val.policyClickToPlay = (packed >> 2) & 1 ? true : false;
    val.critical = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.description = decoder.decodeStruct(codec.String);
    val.enabledMode = decoder.decodeStruct(codec.String);
    val.id = decoder.decodeStruct(codec.String);
    val.name = decoder.decodeStruct(codec.String);
    val.updateUrl = decoder.decodeStruct(codec.String);
    val.version = decoder.decodeStruct(codec.String);
    val.pluginFiles = decoder.decodeArrayPointer(new codec.PointerTo(PluginFile));
    return val;
  };

  PluginData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginData.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.alwaysAllowed & 1) << 0
    packed |= (val.trusted & 1) << 1
    packed |= (val.policyClickToPlay & 1) << 2
    packed |= (val.critical & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.description);
    encoder.encodeStruct(codec.String, val.enabledMode);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.updateUrl);
    encoder.encodeStruct(codec.String, val.version);
    encoder.encodeArrayPointer(new codec.PointerTo(PluginFile), val.pluginFiles);
  };
  function PluginsPageHandler_GetPluginsData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginsPageHandler_GetPluginsData_Params.prototype.initDefaults_ = function() {
  };
  PluginsPageHandler_GetPluginsData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginsPageHandler_GetPluginsData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PluginsPageHandler_GetPluginsData_Params.encodedSize = codec.kStructHeaderSize + 0;

  PluginsPageHandler_GetPluginsData_Params.decode = function(decoder) {
    var packed;
    var val = new PluginsPageHandler_GetPluginsData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PluginsPageHandler_GetPluginsData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginsPageHandler_GetPluginsData_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PluginsPageHandler_GetPluginsData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginsPageHandler_GetPluginsData_ResponseParams.prototype.initDefaults_ = function() {
    this.plugins = null;
  };
  PluginsPageHandler_GetPluginsData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginsPageHandler_GetPluginsData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginsPageHandler_GetPluginsData_ResponseParams.plugins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(PluginData), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PluginsPageHandler_GetPluginsData_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PluginsPageHandler_GetPluginsData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PluginsPageHandler_GetPluginsData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.plugins = decoder.decodeArrayPointer(new codec.PointerTo(PluginData));
    return val;
  };

  PluginsPageHandler_GetPluginsData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginsPageHandler_GetPluginsData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(PluginData), val.plugins);
  };
  function PluginsPageHandler_GetShowDetails_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginsPageHandler_GetShowDetails_Params.prototype.initDefaults_ = function() {
  };
  PluginsPageHandler_GetShowDetails_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginsPageHandler_GetShowDetails_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PluginsPageHandler_GetShowDetails_Params.encodedSize = codec.kStructHeaderSize + 0;

  PluginsPageHandler_GetShowDetails_Params.decode = function(decoder) {
    var packed;
    var val = new PluginsPageHandler_GetShowDetails_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PluginsPageHandler_GetShowDetails_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginsPageHandler_GetShowDetails_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PluginsPageHandler_GetShowDetails_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginsPageHandler_GetShowDetails_ResponseParams.prototype.initDefaults_ = function() {
    this.showDetails = false;
  };
  PluginsPageHandler_GetShowDetails_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginsPageHandler_GetShowDetails_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PluginsPageHandler_GetShowDetails_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PluginsPageHandler_GetShowDetails_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PluginsPageHandler_GetShowDetails_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.showDetails = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PluginsPageHandler_GetShowDetails_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginsPageHandler_GetShowDetails_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.showDetails & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PluginsPageHandler_SaveShowDetailsToPrefs_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginsPageHandler_SaveShowDetailsToPrefs_Params.prototype.initDefaults_ = function() {
    this.detailsMode = false;
  };
  PluginsPageHandler_SaveShowDetailsToPrefs_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginsPageHandler_SaveShowDetailsToPrefs_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PluginsPageHandler_SaveShowDetailsToPrefs_Params.encodedSize = codec.kStructHeaderSize + 8;

  PluginsPageHandler_SaveShowDetailsToPrefs_Params.decode = function(decoder) {
    var packed;
    var val = new PluginsPageHandler_SaveShowDetailsToPrefs_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.detailsMode = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PluginsPageHandler_SaveShowDetailsToPrefs_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginsPageHandler_SaveShowDetailsToPrefs_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.detailsMode & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PluginsPageHandler_SetPluginAlwaysAllowed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginsPageHandler_SetPluginAlwaysAllowed_Params.prototype.initDefaults_ = function() {
    this.plugin = null;
    this.allowed = false;
  };
  PluginsPageHandler_SetPluginAlwaysAllowed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginsPageHandler_SetPluginAlwaysAllowed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginsPageHandler_SetPluginAlwaysAllowed_Params.plugin
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PluginsPageHandler_SetPluginAlwaysAllowed_Params.encodedSize = codec.kStructHeaderSize + 16;

  PluginsPageHandler_SetPluginAlwaysAllowed_Params.decode = function(decoder) {
    var packed;
    var val = new PluginsPageHandler_SetPluginAlwaysAllowed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.plugin = decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.allowed = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PluginsPageHandler_SetPluginAlwaysAllowed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginsPageHandler_SetPluginAlwaysAllowed_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.plugin);
    packed = 0;
    packed |= (val.allowed & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PluginsPageHandler_SetPluginEnabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginsPageHandler_SetPluginEnabled_Params.prototype.initDefaults_ = function() {
    this.pluginPath = null;
    this.enable = false;
  };
  PluginsPageHandler_SetPluginEnabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginsPageHandler_SetPluginEnabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginsPageHandler_SetPluginEnabled_Params.pluginPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PluginsPageHandler_SetPluginEnabled_Params.encodedSize = codec.kStructHeaderSize + 16;

  PluginsPageHandler_SetPluginEnabled_Params.decode = function(decoder) {
    var packed;
    var val = new PluginsPageHandler_SetPluginEnabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pluginPath = decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.enable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PluginsPageHandler_SetPluginEnabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginsPageHandler_SetPluginEnabled_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.pluginPath);
    packed = 0;
    packed |= (val.enable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PluginsPageHandler_SetPluginGroupEnabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginsPageHandler_SetPluginGroupEnabled_Params.prototype.initDefaults_ = function() {
    this.groupName = null;
    this.enable = false;
  };
  PluginsPageHandler_SetPluginGroupEnabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginsPageHandler_SetPluginGroupEnabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginsPageHandler_SetPluginGroupEnabled_Params.groupName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PluginsPageHandler_SetPluginGroupEnabled_Params.encodedSize = codec.kStructHeaderSize + 16;

  PluginsPageHandler_SetPluginGroupEnabled_Params.decode = function(decoder) {
    var packed;
    var val = new PluginsPageHandler_SetPluginGroupEnabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.groupName = decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.enable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PluginsPageHandler_SetPluginGroupEnabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginsPageHandler_SetPluginGroupEnabled_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.groupName);
    packed = 0;
    packed |= (val.enable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PluginsPageHandler_SetClientPage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginsPageHandler_SetClientPage_Params.prototype.initDefaults_ = function() {
    this.page = new PluginsPagePtr();
  };
  PluginsPageHandler_SetClientPage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginsPageHandler_SetClientPage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginsPageHandler_SetClientPage_Params.page
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PluginsPageHandler_SetClientPage_Params.encodedSize = codec.kStructHeaderSize + 8;

  PluginsPageHandler_SetClientPage_Params.decode = function(decoder) {
    var packed;
    var val = new PluginsPageHandler_SetClientPage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.page = decoder.decodeStruct(new codec.Interface(PluginsPagePtr));
    return val;
  };

  PluginsPageHandler_SetClientPage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginsPageHandler_SetClientPage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(PluginsPagePtr), val.page);
  };
  function PluginsPage_OnPluginsUpdated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PluginsPage_OnPluginsUpdated_Params.prototype.initDefaults_ = function() {
    this.plugins = null;
  };
  PluginsPage_OnPluginsUpdated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PluginsPage_OnPluginsUpdated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PluginsPage_OnPluginsUpdated_Params.plugins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(PluginData), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PluginsPage_OnPluginsUpdated_Params.encodedSize = codec.kStructHeaderSize + 8;

  PluginsPage_OnPluginsUpdated_Params.decode = function(decoder) {
    var packed;
    var val = new PluginsPage_OnPluginsUpdated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.plugins = decoder.decodeArrayPointer(new codec.PointerTo(PluginData));
    return val;
  };

  PluginsPage_OnPluginsUpdated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PluginsPage_OnPluginsUpdated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(PluginData), val.plugins);
  };
  var kPluginsPageHandler_GetPluginsData_Name = 1797767405;
  var kPluginsPageHandler_GetShowDetails_Name = 1915196221;
  var kPluginsPageHandler_SaveShowDetailsToPrefs_Name = 272218681;
  var kPluginsPageHandler_SetPluginAlwaysAllowed_Name = 1763192056;
  var kPluginsPageHandler_SetPluginEnabled_Name = 1003739629;
  var kPluginsPageHandler_SetPluginGroupEnabled_Name = 1650940951;
  var kPluginsPageHandler_SetClientPage_Name = 492910145;

  function PluginsPageHandlerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PluginsPageHandler,
                                                   handleOrPtrInfo);
  }

  function PluginsPageHandlerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PluginsPageHandler, associatedInterfacePtrInfo);
  }

  PluginsPageHandlerAssociatedPtr.prototype =
      Object.create(PluginsPageHandlerPtr.prototype);
  PluginsPageHandlerAssociatedPtr.prototype.constructor =
      PluginsPageHandlerAssociatedPtr;

  function PluginsPageHandlerProxy(receiver) {
    this.receiver_ = receiver;
  }
  PluginsPageHandlerPtr.prototype.getPluginsData = function() {
    return PluginsPageHandlerProxy.prototype.getPluginsData
        .apply(this.ptr.getProxy(), arguments);
  };

  PluginsPageHandlerProxy.prototype.getPluginsData = function() {
    var params_ = new PluginsPageHandler_GetPluginsData_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPluginsPageHandler_GetPluginsData_Name,
          codec.align(PluginsPageHandler_GetPluginsData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PluginsPageHandler_GetPluginsData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PluginsPageHandler_GetPluginsData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PluginsPageHandlerPtr.prototype.getShowDetails = function() {
    return PluginsPageHandlerProxy.prototype.getShowDetails
        .apply(this.ptr.getProxy(), arguments);
  };

  PluginsPageHandlerProxy.prototype.getShowDetails = function() {
    var params_ = new PluginsPageHandler_GetShowDetails_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPluginsPageHandler_GetShowDetails_Name,
          codec.align(PluginsPageHandler_GetShowDetails_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PluginsPageHandler_GetShowDetails_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PluginsPageHandler_GetShowDetails_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PluginsPageHandlerPtr.prototype.saveShowDetailsToPrefs = function() {
    return PluginsPageHandlerProxy.prototype.saveShowDetailsToPrefs
        .apply(this.ptr.getProxy(), arguments);
  };

  PluginsPageHandlerProxy.prototype.saveShowDetailsToPrefs = function(detailsMode) {
    var params_ = new PluginsPageHandler_SaveShowDetailsToPrefs_Params();
    params_.detailsMode = detailsMode;
    var builder = new codec.MessageV0Builder(
        kPluginsPageHandler_SaveShowDetailsToPrefs_Name,
        codec.align(PluginsPageHandler_SaveShowDetailsToPrefs_Params.encodedSize));
    builder.encodeStruct(PluginsPageHandler_SaveShowDetailsToPrefs_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PluginsPageHandlerPtr.prototype.setPluginAlwaysAllowed = function() {
    return PluginsPageHandlerProxy.prototype.setPluginAlwaysAllowed
        .apply(this.ptr.getProxy(), arguments);
  };

  PluginsPageHandlerProxy.prototype.setPluginAlwaysAllowed = function(plugin, allowed) {
    var params_ = new PluginsPageHandler_SetPluginAlwaysAllowed_Params();
    params_.plugin = plugin;
    params_.allowed = allowed;
    var builder = new codec.MessageV0Builder(
        kPluginsPageHandler_SetPluginAlwaysAllowed_Name,
        codec.align(PluginsPageHandler_SetPluginAlwaysAllowed_Params.encodedSize));
    builder.encodeStruct(PluginsPageHandler_SetPluginAlwaysAllowed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PluginsPageHandlerPtr.prototype.setPluginEnabled = function() {
    return PluginsPageHandlerProxy.prototype.setPluginEnabled
        .apply(this.ptr.getProxy(), arguments);
  };

  PluginsPageHandlerProxy.prototype.setPluginEnabled = function(pluginPath, enable) {
    var params_ = new PluginsPageHandler_SetPluginEnabled_Params();
    params_.pluginPath = pluginPath;
    params_.enable = enable;
    var builder = new codec.MessageV0Builder(
        kPluginsPageHandler_SetPluginEnabled_Name,
        codec.align(PluginsPageHandler_SetPluginEnabled_Params.encodedSize));
    builder.encodeStruct(PluginsPageHandler_SetPluginEnabled_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PluginsPageHandlerPtr.prototype.setPluginGroupEnabled = function() {
    return PluginsPageHandlerProxy.prototype.setPluginGroupEnabled
        .apply(this.ptr.getProxy(), arguments);
  };

  PluginsPageHandlerProxy.prototype.setPluginGroupEnabled = function(groupName, enable) {
    var params_ = new PluginsPageHandler_SetPluginGroupEnabled_Params();
    params_.groupName = groupName;
    params_.enable = enable;
    var builder = new codec.MessageV0Builder(
        kPluginsPageHandler_SetPluginGroupEnabled_Name,
        codec.align(PluginsPageHandler_SetPluginGroupEnabled_Params.encodedSize));
    builder.encodeStruct(PluginsPageHandler_SetPluginGroupEnabled_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PluginsPageHandlerPtr.prototype.setClientPage = function() {
    return PluginsPageHandlerProxy.prototype.setClientPage
        .apply(this.ptr.getProxy(), arguments);
  };

  PluginsPageHandlerProxy.prototype.setClientPage = function(page) {
    var params_ = new PluginsPageHandler_SetClientPage_Params();
    params_.page = page;
    var builder = new codec.MessageV0Builder(
        kPluginsPageHandler_SetClientPage_Name,
        codec.align(PluginsPageHandler_SetClientPage_Params.encodedSize));
    builder.encodeStruct(PluginsPageHandler_SetClientPage_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PluginsPageHandlerStub(delegate) {
    this.delegate_ = delegate;
  }
  PluginsPageHandlerStub.prototype.getPluginsData = function() {
    return this.delegate_ && this.delegate_.getPluginsData && this.delegate_.getPluginsData();
  }
  PluginsPageHandlerStub.prototype.getShowDetails = function() {
    return this.delegate_ && this.delegate_.getShowDetails && this.delegate_.getShowDetails();
  }
  PluginsPageHandlerStub.prototype.saveShowDetailsToPrefs = function(detailsMode) {
    return this.delegate_ && this.delegate_.saveShowDetailsToPrefs && this.delegate_.saveShowDetailsToPrefs(detailsMode);
  }
  PluginsPageHandlerStub.prototype.setPluginAlwaysAllowed = function(plugin, allowed) {
    return this.delegate_ && this.delegate_.setPluginAlwaysAllowed && this.delegate_.setPluginAlwaysAllowed(plugin, allowed);
  }
  PluginsPageHandlerStub.prototype.setPluginEnabled = function(pluginPath, enable) {
    return this.delegate_ && this.delegate_.setPluginEnabled && this.delegate_.setPluginEnabled(pluginPath, enable);
  }
  PluginsPageHandlerStub.prototype.setPluginGroupEnabled = function(groupName, enable) {
    return this.delegate_ && this.delegate_.setPluginGroupEnabled && this.delegate_.setPluginGroupEnabled(groupName, enable);
  }
  PluginsPageHandlerStub.prototype.setClientPage = function(page) {
    return this.delegate_ && this.delegate_.setClientPage && this.delegate_.setClientPage(page);
  }

  PluginsPageHandlerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPluginsPageHandler_SaveShowDetailsToPrefs_Name:
      var params = reader.decodeStruct(PluginsPageHandler_SaveShowDetailsToPrefs_Params);
      this.saveShowDetailsToPrefs(params.detailsMode);
      return true;
    case kPluginsPageHandler_SetPluginAlwaysAllowed_Name:
      var params = reader.decodeStruct(PluginsPageHandler_SetPluginAlwaysAllowed_Params);
      this.setPluginAlwaysAllowed(params.plugin, params.allowed);
      return true;
    case kPluginsPageHandler_SetPluginEnabled_Name:
      var params = reader.decodeStruct(PluginsPageHandler_SetPluginEnabled_Params);
      this.setPluginEnabled(params.pluginPath, params.enable);
      return true;
    case kPluginsPageHandler_SetPluginGroupEnabled_Name:
      var params = reader.decodeStruct(PluginsPageHandler_SetPluginGroupEnabled_Params);
      this.setPluginGroupEnabled(params.groupName, params.enable);
      return true;
    case kPluginsPageHandler_SetClientPage_Name:
      var params = reader.decodeStruct(PluginsPageHandler_SetClientPage_Params);
      this.setClientPage(params.page);
      return true;
    default:
      return false;
    }
  };

  PluginsPageHandlerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPluginsPageHandler_GetPluginsData_Name:
      var params = reader.decodeStruct(PluginsPageHandler_GetPluginsData_Params);
      this.getPluginsData().then(function(response) {
        var responseParams =
            new PluginsPageHandler_GetPluginsData_ResponseParams();
        responseParams.plugins = response.plugins;
        var builder = new codec.MessageV1Builder(
            kPluginsPageHandler_GetPluginsData_Name,
            codec.align(PluginsPageHandler_GetPluginsData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PluginsPageHandler_GetPluginsData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPluginsPageHandler_GetShowDetails_Name:
      var params = reader.decodeStruct(PluginsPageHandler_GetShowDetails_Params);
      this.getShowDetails().then(function(response) {
        var responseParams =
            new PluginsPageHandler_GetShowDetails_ResponseParams();
        responseParams.showDetails = response.showDetails;
        var builder = new codec.MessageV1Builder(
            kPluginsPageHandler_GetShowDetails_Name,
            codec.align(PluginsPageHandler_GetShowDetails_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PluginsPageHandler_GetShowDetails_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validatePluginsPageHandlerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPluginsPageHandler_GetPluginsData_Name:
        if (message.expectsResponse())
          paramsClass = PluginsPageHandler_GetPluginsData_Params;
      break;
      case kPluginsPageHandler_GetShowDetails_Name:
        if (message.expectsResponse())
          paramsClass = PluginsPageHandler_GetShowDetails_Params;
      break;
      case kPluginsPageHandler_SaveShowDetailsToPrefs_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PluginsPageHandler_SaveShowDetailsToPrefs_Params;
      break;
      case kPluginsPageHandler_SetPluginAlwaysAllowed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PluginsPageHandler_SetPluginAlwaysAllowed_Params;
      break;
      case kPluginsPageHandler_SetPluginEnabled_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PluginsPageHandler_SetPluginEnabled_Params;
      break;
      case kPluginsPageHandler_SetPluginGroupEnabled_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PluginsPageHandler_SetPluginGroupEnabled_Params;
      break;
      case kPluginsPageHandler_SetClientPage_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PluginsPageHandler_SetClientPage_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePluginsPageHandlerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kPluginsPageHandler_GetPluginsData_Name:
        if (message.isResponse())
          paramsClass = PluginsPageHandler_GetPluginsData_ResponseParams;
        break;
      case kPluginsPageHandler_GetShowDetails_Name:
        if (message.isResponse())
          paramsClass = PluginsPageHandler_GetShowDetails_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var PluginsPageHandler = {
    name: 'mojom.PluginsPageHandler',
    kVersion: 0,
    ptrClass: PluginsPageHandlerPtr,
    proxyClass: PluginsPageHandlerProxy,
    stubClass: PluginsPageHandlerStub,
    validateRequest: validatePluginsPageHandlerRequest,
    validateResponse: validatePluginsPageHandlerResponse,
  };
  PluginsPageHandlerStub.prototype.validator = validatePluginsPageHandlerRequest;
  PluginsPageHandlerProxy.prototype.validator = validatePluginsPageHandlerResponse;
  var kPluginsPage_OnPluginsUpdated_Name = 1336044137;

  function PluginsPagePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PluginsPage,
                                                   handleOrPtrInfo);
  }

  function PluginsPageAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PluginsPage, associatedInterfacePtrInfo);
  }

  PluginsPageAssociatedPtr.prototype =
      Object.create(PluginsPagePtr.prototype);
  PluginsPageAssociatedPtr.prototype.constructor =
      PluginsPageAssociatedPtr;

  function PluginsPageProxy(receiver) {
    this.receiver_ = receiver;
  }
  PluginsPagePtr.prototype.onPluginsUpdated = function() {
    return PluginsPageProxy.prototype.onPluginsUpdated
        .apply(this.ptr.getProxy(), arguments);
  };

  PluginsPageProxy.prototype.onPluginsUpdated = function(plugins) {
    var params_ = new PluginsPage_OnPluginsUpdated_Params();
    params_.plugins = plugins;
    var builder = new codec.MessageV0Builder(
        kPluginsPage_OnPluginsUpdated_Name,
        codec.align(PluginsPage_OnPluginsUpdated_Params.encodedSize));
    builder.encodeStruct(PluginsPage_OnPluginsUpdated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PluginsPageStub(delegate) {
    this.delegate_ = delegate;
  }
  PluginsPageStub.prototype.onPluginsUpdated = function(plugins) {
    return this.delegate_ && this.delegate_.onPluginsUpdated && this.delegate_.onPluginsUpdated(plugins);
  }

  PluginsPageStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPluginsPage_OnPluginsUpdated_Name:
      var params = reader.decodeStruct(PluginsPage_OnPluginsUpdated_Params);
      this.onPluginsUpdated(params.plugins);
      return true;
    default:
      return false;
    }
  };

  PluginsPageStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePluginsPageRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPluginsPage_OnPluginsUpdated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PluginsPage_OnPluginsUpdated_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePluginsPageResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PluginsPage = {
    name: 'mojom.PluginsPage',
    kVersion: 0,
    ptrClass: PluginsPagePtr,
    proxyClass: PluginsPageProxy,
    stubClass: PluginsPageStub,
    validateRequest: validatePluginsPageRequest,
    validateResponse: null,
  };
  PluginsPageStub.prototype.validator = validatePluginsPageRequest;
  PluginsPageProxy.prototype.validator = null;
  exports.MimeType = MimeType;
  exports.PluginFile = PluginFile;
  exports.PluginData = PluginData;
  exports.PluginsPageHandler = PluginsPageHandler;
  exports.PluginsPageHandlerPtr = PluginsPageHandlerPtr;
  exports.PluginsPageHandlerAssociatedPtr = PluginsPageHandlerAssociatedPtr;
  exports.PluginsPage = PluginsPage;
  exports.PluginsPagePtr = PluginsPagePtr;
  exports.PluginsPageAssociatedPtr = PluginsPageAssociatedPtr;
})();