// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// #import {Route} from './router.m.js';

/**
 * Specifies all possible routes in settings.
 *
 * @typedef {{
 *   ABOUT: !settings.Route,
 *   ACCESSIBILITY: !settings.Route,
 *   ADVANCED: !settings.Route,
 *   ADDRESSES: !settings.Route,
 *   AMBIENT_MODE: !settings.Route,
 *   APPEARANCE: !settings.Route,
 *   AUTOFILL: !settings.Route,
 *   BASIC: !settings.Route,
 *   CAPTIONS: !settings.Route,
 *   CERTIFICATES: !settings.Route,
 *   CHECK_PASSWORDS: !settings.Route,
 *   CHROME_CLEANUP: !settings.Route,
 *   CLEAR_BROWSER_DATA: !settings.Route,
 *   CLOUD_PRINTERS: !settings.Route,
 *   COOKIES: !settings.Route,
 *   DEFAULT_BROWSER: !settings.Route,
 *   DOWNLOADS: !settings.Route,
 *   EDIT_DICTIONARY: !settings.Route,
 *   FONTS: !settings.Route,
 *   IMPORT_DATA: !settings.Route,
 *   INCOMPATIBLE_APPLICATIONS: !settings.Route,
 *   LANGUAGES: !settings.Route,
 *   MANAGE_PROFILE: !settings.Route,
 *   ON_STARTUP: !settings.Route,
 *   PASSWORDS: !settings.Route,
 *   PAYMENTS: !settings.Route,
 *   PEOPLE: !settings.Route,
 *   PRINTING: !settings.Route,
 *   PRIVACY: !settings.Route,
 *   RESET: !settings.Route,
 *   RESET_DIALOG: !settings.Route,
 *   SEARCH: !settings.Route,
 *   SEARCH_ENGINES: !settings.Route,
 *   SECURITY: !settings.Route,
 *   SECURITY_KEYS: !settings.Route,
 *   SIGN_OUT: !settings.Route,
 *   SITE_SETTINGS: !settings.Route,
 *   SITE_SETTINGS_ADS: !settings.Route,
 *   SITE_SETTINGS_ALL: !settings.Route,
 *   SITE_SETTINGS_AR: !settings.Route,
 *   SITE_SETTINGS_AUTOMATIC_DOWNLOADS: !settings.Route,
 *   SITE_SETTINGS_BACKGROUND_SYNC: !settings.Route,
 *   SITE_SETTINGS_BLUETOOTH_DEVICES: !settings.Route,
 *   SITE_SETTINGS_BLUETOOTH_SCANNING: !settings.Route,
 *   SITE_SETTINGS_CAMERA: !settings.Route,
 *   SITE_SETTINGS_CLIPBOARD: !settings.Route,
 *   SITE_SETTINGS_COOKIES: !settings.Route,
 *   SITE_SETTINGS_DATA_DETAILS: !settings.Route,
 *   SITE_SETTINGS_FLASH: !settings.Route,
 *   SITE_SETTINGS_HANDLERS: !settings.Route,
 *   SITE_SETTINGS_HID_DEVICES: !settings.Route,
 *   SITE_SETTINGS_IMAGES: !settings.Route,
 *   SITE_SETTINGS_MIXEDSCRIPT: !settings.Route,
 *   SITE_SETTINGS_JAVASCRIPT: !settings.Route,
 *   SITE_SETTINGS_SENSORS: !settings.Route,
 *   SITE_SETTINGS_SOUND: !settings.Route,
 *   SITE_SETTINGS_LOCATION: !settings.Route,
 *   SITE_SETTINGS_MICROPHONE: !settings.Route,
 *   SITE_SETTINGS_MIDI_DEVICES: !settings.Route,
 *   SITE_SETTINGS_NATIVE_FILE_SYSTEM_WRITE: !settings.Route,
 *   SITE_SETTINGS_NOTIFICATIONS: !settings.Route,
 *   SITE_SETTINGS_PAYMENT_HANDLER: !settings.Route,
 *   SITE_SETTINGS_PDF_DOCUMENTS: !settings.Route,
 *   SITE_SETTINGS_POPUPS: !settings.Route,
 *   SITE_SETTINGS_PROTECTED_CONTENT: !settings.Route,
 *   SITE_SETTINGS_SITE_DATA: !settings.Route,
 *   SITE_SETTINGS_SITE_DETAILS: !settings.Route,
 *   SITE_SETTINGS_UNSANDBOXED_PLUGINS: !settings.Route,
 *   SITE_SETTINGS_USB_DEVICES: !settings.Route,
 *   SITE_SETTINGS_SERIAL_PORTS: !settings.Route,
 *   SITE_SETTINGS_VR: !settings.Route,
 *   SITE_SETTINGS_ZOOM_LEVELS: !settings.Route,
 *   SYNC: !settings.Route,
 *   SYNC_ADVANCED: !settings.Route,
 *   SYSTEM: !settings.Route,
 *   TRIGGERED_RESET_DIALOG: !settings.Route,
 * }}
 */
/* #export */ let SettingsRoutes;
