// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_PASSWORDS_PASSWORD_BASE_DIALOG_CONTROLLER_H_
#define CHROME_BROWSER_UI_PASSWORDS_PASSWORD_BASE_DIALOG_CONTROLLER_H_

// A UI controller responsible for the credential manager and credentials
// leaked dialogs.
class PasswordBaseDialogController {
 public:
  PasswordBaseDialogController() = default;
  virtual ~PasswordBaseDialogController() = default;

  // Returns true if account chooser dialog created by derived credential
  // manager controller is active.
  virtual bool IsShowingAccountChooser() const = 0;

  DISALLOW_COPY_AND_ASSIGN(PasswordBaseDialogController);
};

#endif  // CHROME_BROWSER_UI_PASSWORDS_PASSWORD_BASE_DIALOG_CONTROLLER_H_
