# use cblas
set(CBLAS_FOUND OFF)

if (WIN32)
    find_library(OpenBLAS REQUIRED)
    # include_directories("D:/openblas/0.2.4/include")
    # list(APPEND third_libraries "D:/openblas/0.2.4/lib/x64/libopenblas.lib")
    if (OpenBLAS_FOUND)
        set(CBLAS_FOUND ON)
        include_directories(${OpenBLAS_INCLUDE_DIR})
        list(APPEND third_libraries ${OpenBLAS_LIBRARY})
    endif ()
elseif (IOS)
    SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -Wno-unused-command-line-argument")
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -Wno-unused-command-line-argument")
    SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -framework Accelerate")
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -framework Accelerate")
    set(CBLAS_FOUND ON)
elseif (APPLE)
    message(STATUS "Using Max OS X: Accelerate")
    list(APPEND third_libraries -lcblas)
    set(CBLAS_FOUND ON)
elseif (UNIX)
    find_library(OpenBLAS REQUIRED)
    if (OpenBLAS_FOUND)
        set(CBLAS_FOUND ON)
        include_directories(${OpenBLAS_INCLUDE_DIR})
        list(APPEND third_libraries ${OpenBLAS_LIBRARY})
    endif ()
else ()
    find_library(OpenBLAS REQUIRED)
    if (OpenBLAS_FOUND)
        set(CBLAS_FOUND ON)
        include_directories(${OpenBLAS_INCLUDE_DIR})
        list(APPEND third_libraries ${OpenBLAS_LIBRARY})
    endif ()
endif ()
if (NOT CBLAS_FOUND)
    # include_directories("/opt/OpenBLAS/include")
    # link_directories("/opt/OpenBLAS/lib")
    list(APPEND third_libraries -lopenblas)
endif ()