//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------

// GTK text edit widget for getting keyboard button values (for binding keys)
// put cursor in text box, hit a key, something like  'a' (42)  appears...
// each keypress replaces the previous text.
// also supports keyevent and keygroup maps in the perform class

#pragma once

#include <gtkmm/entry.h>


/*forward declaration*/
class perform;


class KeyBindEntry : public Gtk::Entry
{

public:
    enum type { location, events, groups };

    KeyBindEntry(type t, unsigned int* location_to_write = NULL,
            perform* p = NULL, long s = 0);

    void set( unsigned int val );
    virtual bool on_key_press_event(GdkEventKey* event);

private:
    unsigned int* m_key;
    type m_type;
    perform* m_perf;
    long m_slot;
};

