package require geoip
puts "\t Testing db_avail"
set foundcountry [geoip db_avail country_edition]
puts "country_edition \t $foundcountry"
set foundcity [geoip db_avail city_edition_rev1]
puts "city_edition_rev1 \t $foundcity"
set foundregion [geoip db_avail region_edition_rev1]
puts "region_edition_rev1  \t $foundregion"
set foundisp [geoip db_avail isp_edition]
puts "isp_edition_rev1 \t $foundisp"
set foundasnum [geoip db_avail asnum_edition]
puts "asnum_edition \t\t $foundasnum"
set foundorg [geoip db_avail org_edition]
puts "org_edition \t\t $foundorg"


puts "\n\tTesting found databases\n"
if { $foundcountry } {
	puts "\tGeoIP Country Edition"
	puts [geoip open -type country_edition -flags standard]

	puts "Country code/code3 by addr" 
	puts -nonewline "130.88.199.8 -> " 
	puts [geoip country_code_by_addr 130.88.199.8]
	puts -nonewline "124.121.21.10 -> " 
	puts [geoip country_code_by_addr 124.121.21.10] 
	puts -nonewline "151.35.80.202 -> " 
	puts [geoip country_code3_by_addr 151.35.80.202]
	puts -nonewline "192.106.51.100 -> " 
	puts [geoip country_code3_by_addr 192.106.51.100]

	puts "\nCountry code/code3 by name"
	puts -nonewline "www.arabeyes.org -> " 
	puts [geoip country_code_by_name www.arabeyes.org]
	puts -nonewline "www.yahoo.co.uk -> " 
	puts [geoip country_code_by_name www.yahoo.co.uk]
	puts -nonewline "www.djihed.com -> " 
	puts [geoip country_code3_by_name www.djihed.com]
	puts -nonewline "www.arabeyes.org -> " 
	puts [geoip country_code3_by_name www.arabeyes.org]

	puts "\nCountry full name by addr/name"
	puts -nonewline "193.75.148.28 -> " 
	puts [geoip country_name_by_addr 193.75.148.28]
	puts -nonewline "151.42.169.71 -> " 
	puts [geoip country_name_by_addr 151.42.169.71]
	puts -nonewline "www.linux-france.org -> " 
	puts [geoip country_name_by_name www.linux-france.org]
	puts -nonewline "www.yahoo.co.kr -> " 
	puts [geoip country_name_by_name www.yahoo.co.kr]
}

if { $foundasnum } {
	puts "\n\tGeoIP ASNum Edition"
	puts [geoip open -type asnum_edition -flags standard]
	puts -nonewline "193.56.4.124 -> " 
	puts [geoip name_by_addr 193.56.4.124]
	puts -nonewline "151.42.169.71 -> " 
	puts [geoip name_by_addr 151.42.169.71]
	puts -nonewline "www.cs.man.ac.uk -> " 
	puts [geoip name_by_name www.cs.man.ac.uk]
	puts -nonewline "www.djihed.com -> " 
	puts [geoip name_by_name www.djihed.com]
}

if { $foundorg } { 
	puts "\n\tGeoIP Org Edition"
	puts [geoip open -type org_edition -flags standard]
	puts -nonewline "193.56.4.124 -> " 
	puts [geoip name_by_addr 193.56.4.124]
	puts -nonewline "151.42.169.71 -> "
	puts [geoip name_by_addr 151.42.169.71]
	puts -nonewline "www.cs.man.ac.uk -> "
	puts [geoip name_by_name www.cs.man.ac.uk]
	puts -nonewline "www.djihed.com -> "
	puts [geoip name_by_name www.arabeyes.org]
}

if { $foundisp } {
	puts "\nGeoIP ISP Edition"
	puts [geoip open -type isp_edition -flags standard]
	puts -nonewline "193.56.4.124 -> "
	puts [geoip name_by_addr 193.56.4.124]
	puts -nonewline "151.42.169.71 -> "
	puts [geoip name_by_addr 151.42.169.71]
	puts -nonewline "www.cs.man.ac.uk -> "
	puts [geoip name_by_name www.cs.man.ac.uk]
	puts -nonewline "www.arabeyes.org -> "
	puts [geoip name_by_name www.arabeyes.org]
}

if { $foundcity } {
	puts "\n\tGeoIP City Edition"
	puts [geoip open -type city_edition_rev1 -flags standard]
	puts -nonewline "news.bbc.co.uk -> "
	puts [geoip record_by_name news.bbc.co.uk]
	puts -nonewline "www.arabeyes.org -> "
	puts [geoip record_by_name www.arabeyes.org]
	puts -nonewline "192.116.21.188 -> "
	puts [geoip record_by_addr 192.116.21.188]
	puts -nonewline "130.88.199.8 -> "
	puts [geoip record_by_addr 130.88.199.8]
}

puts [geoip close]

