/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef __UOSCODECONV_H__
#define __UOSCODECONV_H__

#include "libsylph/codeconv.h"

typedef CodeConverter UosCodeConverter;

typedef CharSet UosCharSet;
#define UosC_AUTO C_AUTO
#define UosC_US_ASCII C_US_ASCII
#define UosC_UTF_8 C_UTF_8
#define UosC_UTF_7 C_UTF_7
#define UosC_ISO_8859_1 C_ISO_8859_1
#define UosC_ISO_8859_2 C_ISO_8859_2
#define UosC_ISO_8859_3 C_ISO_8859_3
#define UosC_ISO_8859_4 C_ISO_8859_4
#define UosC_ISO_8859_5 C_ISO_8859_5
#define UosC_ISO_8859_6 C_ISO_8859_6
#define UosC_ISO_8859_7 C_ISO_8859_7
#define UosC_ISO_8859_8 C_ISO_8859_8
#define UosC_ISO_8859_9 C_ISO_8859_9
#define UosC_ISO_8859_10 C_ISO_8859_10
#define UosC_ISO_8859_12 C_ISO_8859_12
#define UosC_ISO_8859_13 C_ISO_8859_13
#define UosC_ISO_8859_14 C_ISO_8859_14
#define UosC_ISO_8859_15 C_ISO_8859_15
#define UosC_BALTIC C_BALTIC
#define UosC_CP932 C_CP932
#define UosC_CP1250 C_CP1250
#define UosC_CP1251 C_CP1251
#define UosC_CP1252 C_CP1252
#define UosC_CP1253 C_CP1253
#define UosC_CP1254 C_CP1254
#define UosC_CP1255 C_CP1255
#define UosC_CP1256 C_CP1256
#define UosC_CP1257 C_CP1257
#define UosC_CP1258 C_CP1258
#define UosC_WINDOWS_932 C_WINDOWS_932
#define UosC_WINDOWS_1250 C_WINDOWS_1250
#define UosC_WINDOWS_1251 C_WINDOWS_1251
#define UosC_WINDOWS_1252 C_WINDOWS_1252
#define UosC_WINDOWS_1253 C_WINDOWS_1253
#define UosC_WINDOWS_1254 C_WINDOWS_1254
#define UosC_WINDOWS_1255 C_WINDOWS_1255
#define UosC_WINDOWS_1256 C_WINDOWS_1256
#define UosC_WINDOWS_1257 C_WINDOWS_1257
#define UosC_WINDOWS_1258 C_WINDOWS_1258
#define UosC_KOI8_R C_KOI8_R
#define UosC_KOI8_T C_KOI8_T
#define UosC_KOI8_U C_KOI8_U
#define UosC_ISO_2022_JP C_ISO_2022_JP
#define UosC_ISO_2022_JP_2 C_ISO_2022_JP_2
#define UosC_ISO_2022_JP_3 C_ISO_2022_JP_3
#define UosC_EUC_JP C_EUC_JP
#define UosC_EUC_JP_MS C_EUC_JP_MS
#define UosC_SHIFT_JIS C_SHIFT_JIS
#define UosC_ISO_2022_KR C_ISO_2022_KR
#define UosC_EUC_KR C_EUC_KR
#define UosC_ISO_2022_CN C_ISO_2022_CN
#define UosC_EUC_CN C_EUC_CN
#define UosC_GB2312 C_GB2312
#define UosC_GBK C_GBK
#define UosC_EUC_TW C_EUC_TW
#define UosC_BIG5 C_BIG5
#define UosC_BIG5_HKSCS C_BIG5_HKSCS
#define UosC_TIS_620 C_TIS_620
#define UosC_WINDOWS_874 C_WINDOWS_874
#define UosC_GEORGIAN_PS C_GEORGIAN_PS
#define UosC_TCVN5712_1 C_TCVN5712_1
#define UosC_ISO_8859_16 C_ISO_8859_16
#define UosC_UTF_16 C_UTF_16
#define UosC_UTF_16BE C_UTF_16BE
#define UosC_UTF_16LE C_UTF_16LE

typedef ConvADType UosConvADType;
#define UosC_AD_BY_LOCALE C_AD_BY_LOCALE
#define UosC_AD_NEVER C_AD_NEVER
#define UosC_AD_JAPANESE C_AD_JAPANESE

typedef CodeConvFunc UosCodeConvFunc;

#define UOSCS_AUTO	CS_AUTO
#define UOSCS_US_ASCII	CS_US_ASCII
#define UOSCS_ANSI_X3_4_1968 CS_ANSI_X3_4_1968
#define UOSCS_UTF_8		CS_UTF_8
#define UOSCS_UTF_7		CS_UTF_7
#define UOSCS_ISO_8859_1	CS_ISO_8859_1
#define UOSCS_ISO_8859_2	CS_ISO_8859_2
#define UOSCS_ISO_8859_3	CS_ISO_8859_3
#define UOSCS_ISO_8859_4	CS_ISO_8859_4
#define UOSCS_ISO_8859_5	CS_ISO_8859_5
#define UOSCS_ISO_8859_6	CS_ISO_8859_6
#define UOSCS_ISO_8859_7	CS_ISO_8859_7
#define UOSCS_ISO_8859_8	CS_ISO_8859_8
#define UOSCS_ISO_8859_9	CS_ISO_8859_9
#define UOSCS_ISO_8859_10	CS_ISO_8859_10
#define UOSCS_ISO_8859_11	CS_ISO_8859_11
#define UOSCS_ISO_8859_13	CS_ISO_8859_13
#define UOSCS_ISO_8859_14	CS_ISO_8859_14
#define UOSCS_ISO_8859_15	CS_ISO_8859_15
#define UOSCS_BALTIC	CS_BALTIC
#define UOSCS_CP932	CS_CP932
#define UOSCS_CP1250	CS_CP1250
#define UOSCS_CP1251	CS_CP1251
#define UOSCS_CP1252	CS_CP1252
#define UOSCS_CP1253	CS_CP1253
#define UOSCS_CP1254	CS_CP1254
#define UOSCS_CP1255	CS_CP1255
#define UOSCS_CP1256	CS_CP1256
#define UOSCS_CP1257	CS_CP1257
#define UOSCS_CP1258	CS_CP1258
#define UOSCS_WINDOWS_932	CS_WINDOWS_932
#define UOSCS_WINDOWS_1250	CS_WINDOWS_1250
#define UOSCS_WINDOWS_1251	CS_WINDOWS_1251
#define UOSCS_WINDOWS_1252	CS_WINDOWS_1252
#define UOSCS_WINDOWS_1253	CS_WINDOWS_1253
#define UOSCS_WINDOWS_1254	CS_WINDOWS_1254
#define UOSCS_WINDOWS_1255	CS_WINDOWS_1255
#define UOSCS_WINDOWS_1256	CS_WINDOWS_1256
#define UOSCS_WINDOWS_1257	CS_WINDOWS_1257
#define UOSCS_WINDOWS_1258	CS_WINDOWS_1258
#define UOSCS_KOI8_R	CS_KOI8_R
#define UOSCS_KOI8_T	CS_KOI8_T
#define UOSCS_KOI8_U	CS_KOI8_U
#define UOSCS_ISO_2022_JP	CS_ISO_2022_JP
#define UOSCS_ISO_2022_JP_2    CS_ISO_2022_JP_2
#define UOSCS_ISO_2022_JP_3	CS_ISO_2022_JP_3
#define UOSCS_EUC_JP	CS_EUC_JP
#define UOSCS_EUCJP	CS_EUCJP
#define UOSCS_EUC_JP_MS	CS_EUC_JP_MS
#define UOSCS_SHIFT_JIS	CS_SHIFT_JIS
#define UOSCS_SHIFT__JIS	CS_SHIFT__JIS
#define UOSCS_SJIS	CS_SJIS
#define UOSCS_X_SJIS	CS_X_SJIS
#define UOSCS_ISO_2022_KR	CS_ISO_2022_KR
#define UOSCS_EUC_KR	CS_EUC_KR
#define UOSCS_KS_C_5601_1987	CS_KS_C_5601_1987
#define UOSCS_ISO_2022_CN	CS_ISO_2022_CN
#define UOSCS_EUC_CN	CS_EUC_CN
#define UOSCS_GB2312	CS_GB2312
#define UOSCS_GBK		CS_GBK
#define UOSCS_X_GBK	CS_X_GBK
#define UOSCS_EUC_TW	CS_EUC_TW
#define UOSCS_BIG5		CS_BIG5
#define UOSCS_BIG5_HKSCS	CS_BIG5_HKSCS
#define UOSCS_TIS_620	CS_TIS_620
#define UOSCS_WINDOWS_874	CS_WINDOWS_874
#define UOSCS_GEORGIAN_PS	CS_GEORGIAN_PS
#define UOSCS_TCVN5712_1	CS_TCVN5712_1
#define UOSCS_ISO_8859_16	CS_ISO_8859_16
#define UOSCS_UTF_16	CS_UTF_16
#define UOSCS_UTF_16BE	CS_UTF_16BE
#define UOSCS_UTF_16LE	CS_UTF_16LE

#define UOSC_INTERNAL	C_INTERNAL
#define UOSCS_INTERNAL	CS_INTERNAL

UosCharSet uos_conv_guess_ja_encoding		(const gchar	*str);

gchar *uos_conv_utf8todisp			(const gchar	*inbuf,
					 gint		*error);
gchar *uos_conv_localetodisp		(const gchar	*inbuf,
					 gint		*error);

UosCodeConverter *uos_conv_code_converter_new	(const gchar	*src_encoding,
					 const gchar	*dest_encoding);
void uos_conv_code_converter_destroy	(UosCodeConverter	*conv);
gchar *uos_conv_convert			(UosCodeConverter	*conv,
					 const gchar	*inbuf);

#define uosconv_codeset_strdup(inbuf, src_code, dest_code) conv_codeset_strdup(inbuf, src_code, dest_code)

gchar *uos_conv_codeset_strdup_full		(const gchar	*inbuf,
					 const gchar	*src_encoding,
					 const gchar	*dest_encoding,
					 gint		*error);

UosCodeConvFunc uos_conv_get_code_conv_func	(const gchar	*src_encoding,
					 const gchar	*dest_encoding);

gchar *uos_conv_iconv_strdup		(const gchar	*inbuf,
					 const gchar	*src_encoding,
					 const gchar	*dest_encoding,
					 gint		*error);
gchar *uos_conv_iconv_strdup_with_cd	(const gchar	*inbuf,
					 iconv_t	 cd,
					 gint		*error);

const gchar *uos_conv_get_charset_str		(UosCharSet	 charset);
UosCharSet uos_conv_get_charset_from_str		(const gchar	*charset);
UosCharSet uos_conv_get_locale_charset			(void);
const gchar *uos_conv_get_locale_charset_str	(void);
UosCharSet uos_conv_get_internal_charset		(void);
const gchar *uos_conv_get_internal_charset_str	(void);
UosCharSet uos_conv_get_outgoing_charset		(void);
const gchar *uos_conv_get_outgoing_charset_str	(void);
gboolean uos_conv_is_multibyte_encoding		(UosCharSet	 encoding);

const gchar *uos_conv_get_current_locale		(void);
gboolean uos_conv_is_ja_locale			(void);

void uos_conv_set_autodetect_type			(UosConvADType	 type);
UosConvADType uos_conv_get_autodetect_type		(void);

gchar *uos_conv_unmime_header		(const gchar	*str,
					 const gchar	*default_encoding);
void uos_conv_encode_header			(gchar		*dest,
					 gint		 len,
					 const gchar	*src,
					 gint		 header_len,
					 gboolean	 addr_field,
					 const gchar	*out_encoding);
gchar *uos_conv_encode_filename		(const gchar	*src,
					 const gchar	*param_name,
					 const gchar	*out_encoding);

gint uos_conv_copy_file			(const gchar	*src,
					 const gchar	*dest,
					 const gchar	*src_encoding);
gint uos_conv_copy_dir			(const gchar	*src,
					 const gchar	*dest,
					 const gchar	*src_encoding);

UosCharSet uos_conv_check_file_encoding	(const gchar	*file);

gchar *uos_conv_filename_from_utf8		(const gchar	*utf8_file);
gchar *uos_conv_filename_to_utf8		(const gchar	*fs_file);

#endif /* __UOSCODECONV_H__ */
