/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "uosimap.h"

UosFolderClass *uos_imap_get_class(void){
     return imap_get_class();
}

gint uos_imap_msg_set_perm_flags(UosMsgInfo *msginfo,
                             UosMsgPermFlags flags){
    return imap_msg_set_perm_flags(msginfo,flags);
}

gint uos_imap_msg_unset_perm_flags(UosMsgInfo *msginfo,
                               UosMsgPermFlags flags){
    return imap_msg_unset_perm_flags(msginfo,flags);
}

gint uos_imap_msg_list_set_perm_flags(GSList *msglist,
                                  UosMsgPermFlags flags){
    return imap_msg_list_set_perm_flags(msglist,flags);
}

gint uos_imap_msg_list_unset_perm_flags(GSList *msglist,
                                    UosMsgPermFlags flags){
    return imap_msg_list_unset_perm_flags(msglist,flags);
}


gint uos_imap_msg_list_set_colorlabel_flags(GSList *msglist,
                                        guint color){
    return imap_msg_list_set_colorlabel_flags(msglist,color);
}


gboolean uos_imap_is_session_active(UosIMAPFolder *folder){
    return imap_is_session_active(folder);
}

int uos_imap_connect(UosPrefsAccount *account, int *ercode, char **errorchar){
    return imap_connect(account, ercode, errorchar);
}

gchar *uos_imap_fetch_msg_docache(UosFolder *folder, UosFolderItem *item, gint uid){
    return imap_fetch_msg_docache(folder, item, uid);
}

gint uos_imap_scan_folder_docache(UosFolder *folder, UosFolderItem *item){
    return imap_scan_folder_docache(folder, item);
}

gchar *uos_imap_fetch_msg_export(UosFolder *folder, UosFolderItem *item, gint uid){
    return imap_fetch_msg_export(folder, item, uid);
}

gchar *uos_imap_fetch_large_msg(UosFolder *folder, UosFolderItem *item, gint uid){
    return imap_fetch_large_msg(folder, item, uid);
}


void uos_set_imap_get_uncached_messages_progress_func(ImapGetUncachedMessagesProgressFunc func){
    p_imap_get_uncached_messages_progress_func=func;
}

void uos_set_imap_remove_item_func(ImapRemoveItemFunc func){
    p_imap_remove_item_func=func;
}

void uos_set_imap_check_item_canremove_func(ImapCheckItemCanRemoveFunc func){
    p_imap_check_item_canremove_func=func;
}
