/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uosprocmime.h"

UosMimeInfo *uos_procmime_mimeinfo_new     (void){
     return procmime_mimeinfo_new     ();
}

void uos_procmime_mimeinfo_free_all     (UosMimeInfo   *mimeinfo){
    procmime_mimeinfo_free_all     (mimeinfo);
}


UosMimeInfo *uos_procmime_mimeinfo_insert  (UosMimeInfo   *parent,
                                     UosMimeInfo   *mimeinfo){
    return procmime_mimeinfo_insert  (parent,mimeinfo);
}

UosMimeInfo *uos_procmime_mimeinfo_next    (UosMimeInfo   *mimeinfo){
    return procmime_mimeinfo_next  (mimeinfo);
}

UosMimeInfo *uos_procmime_scan_message     (UosMsgInfo    *msginfo){
    return procmime_scan_message     (msginfo);
}

UosMimeInfo *uos_procmime_scan_message_stream  (FILE       *fp){
    return procmime_scan_message_stream  (fp);
}

void uos_procmime_scan_multipart_message    (UosMimeInfo   *mimeinfo,
                                         FILE       *fp){
    procmime_scan_multipart_message    (mimeinfo,fp);
}


void uos_procmime_scan_encoding     (UosMimeInfo   *mimeinfo,
                                 const gchar    *encoding){
    procmime_scan_encoding     (mimeinfo,encoding);
}

void uos_procmime_scan_content_type     (UosMimeInfo   *mimeinfo,
                                     const gchar    *content_type){
    procmime_scan_content_type     (mimeinfo,content_type);
}

void uos_procmime_scan_content_type_str (const gchar    *content_type,
                                     gchar         **mime_type,
                                     gchar         **charset,
                                     gchar         **name,
                                     gchar         **boundary,
                                     gchar         **method){
    procmime_scan_content_type_str (content_type,mime_type,charset,name,boundary,method);
}

void uos_procmime_scan_content_type_partial (const gchar    *content_type,
                                         gint       *total,
                                         gchar         **part_id,
                                         gint       *number){
    procmime_scan_content_type_partial (content_type,total,part_id,number);
}

void uos_procmime_scan_content_id  (UosMimeInfo   *mimeinfo,
                                const gchar    *content_id){
    procmime_scan_content_id  (mimeinfo,content_id);
}

void uos_procmime_scan_content_disposition  (UosMimeInfo   *mimeinfo,
                                         const gchar    *content_disposition){
    procmime_scan_content_disposition  (mimeinfo,content_disposition);
}

UosMimeInfo *uos_procmime_scan_mime_header (FILE       *fp){
    return procmime_scan_mime_header (fp);
}


FILE *uos_procmime_decode_content       (FILE       *outfp,
                                     FILE       *infp,
                                     UosMimeInfo   *mimeinfo){
    return procmime_decode_content       (outfp,infp,mimeinfo);
}

gint uos_procmime_get_part          (const gchar    *outfile,
                                 const gchar    *infile,
                                 UosMimeInfo   *mimeinfo){
    return procmime_get_part          (outfile,infile,mimeinfo);
}

gint uos_procmime_get_part_fp       (const gchar    *outfile,
                                 FILE       *infp,
                                 UosMimeInfo   *mimeinfo){
    return procmime_get_part_fp       (outfile,infp,mimeinfo);
}

FILE *uos_procmime_get_part_fp_fp       (FILE       *outfp,
                                     FILE       *infp,
                                     UosMimeInfo   *mimeinfo){
    return procmime_get_part_fp_fp       (outfp,infp,mimeinfo);
}

gint uos_procmime_get_all_parts     (const gchar    *dir,
                                 const gchar    *infile,
                                 UosMimeInfo   *mimeinfo){
    return procmime_get_all_parts     (dir,infile,mimeinfo);
}

FILE *uos_procmime_get_text_content     (UosMimeInfo   *mimeinfo,
                                     FILE       *infp,
                                     const gchar    *encoding){
    return procmime_get_text_content     (mimeinfo,infp,encoding);
}

FILE *uos_procmime_get_first_text_content   (UosMsgInfo    *msginfo,
                                         const gchar    *encoding){
    return procmime_get_first_text_content   (msginfo,encoding);
}


gboolean uos_procmime_find_string_part  (UosMimeInfo   *mimeinfo,
                                     const gchar    *filename,
                                     const gchar    *str,
                                     UosStrFindFunc     find_func){
    return procmime_find_string_part  (mimeinfo,filename,str,find_func);
}

gboolean uos_procmime_find_string       (UosMsgInfo    *msginfo,
                                     const gchar    *str,
                                     UosStrFindFunc     find_func){
    return procmime_find_string       (msginfo,str,find_func);
}


gchar *uos_procmime_get_part_file_name  (UosMimeInfo   *mimeinfo){
    return procmime_get_part_file_name  (mimeinfo);
}

gchar *uos_procmime_get_tmp_file_name   (UosMimeInfo   *mimeinfo){
    return procmime_get_tmp_file_name  (mimeinfo);
}

gchar *uos_procmime_get_tmp_file_name_for_user(UosMimeInfo   *mimeinfo){
    return procmime_get_tmp_file_name_for_user
            (mimeinfo);
}


UosContentType uos_procmime_scan_mime_type (const gchar    *mime_type){
    return procmime_scan_mime_type (mime_type);
}

gchar *uos_procmime_get_mime_type       (const gchar    *filename){
    return procmime_get_mime_type       (filename);
}


gint uos_procmime_execute_open_file     (const gchar    *file,
                                     const gchar    *mime_type){
    return procmime_execute_open_file     (file,mime_type);
}


UosEncodingType uos_procmime_get_encoding_for_charset  (const gchar    *charset){
    return procmime_get_encoding_for_charset  (charset);
}

UosEncodingType uos_procmime_get_encoding_for_text_file(const gchar    *file){
    return procmime_get_encoding_for_text_file(file);
}

UosEncodingType uos_procmime_get_encoding_for_str  (const gchar    *str){
    return procmime_get_encoding_for_str  (str);
}

const gchar *uos_procmime_get_encoding_str      (UosEncodingType    encoding){
    return procmime_get_encoding_str      (encoding);
}

