#include <assert.h>
#include <sys/time.h>

#include "timespec.h"

timespec clock_diff(const timespec &a, const timespec &b)
{
	timespec ret;
	ret.tv_sec = b.tv_sec - a.tv_sec;
	ret.tv_nsec = b.tv_nsec - a.tv_nsec;
	if (ret.tv_nsec < 0) {
		ret.tv_sec--;
		ret.tv_nsec += 1000000000;
	}
	assert(ret.tv_nsec >= 0);
	return ret;
}

timespec clock_add(const timespec &a, const timespec &b)
{
	timespec ret;
	ret.tv_sec = a.tv_sec + b.tv_sec;
	ret.tv_nsec = b.tv_nsec + b.tv_nsec;

	ret.tv_sec += ret.tv_nsec / 1000000000;
	ret.tv_nsec %= 1000000000;
	return ret;
}
