/**
 * \file        linFirDesignDlg.h
 * \brief       Linear FIR filter dialog functions.
 * \copyright   Copyright (C) 2006-2022 Ralf Hoppe <ralf.hoppe@dfcgen.de>
 */

#ifndef LINFIRDESIGNDLG_H
#define LINFIRDESIGNDLG_H


/* INCLUDE FILES **************************************************************/

#include "gui.h"
#include "cfgSettings.h"


#ifdef  __cplusplus
extern "C" {
#endif


/* GLOBAL TYPE DECLARATIONS ***************************************************/


/* GLOBAL CONSTANT DECLARATIONS ***********************************************/


/* GLOBAL VARIABLE DECLARATIONS ***********************************************/


/* GLOBAL MACRO DEFINITIONS ***************************************************/


/* EXPORTED FUNCTIONS *********************************************************/


/* FUNCTION *******************************************************************/
/** Linear FIR filter design dialog creation function. This function is
 *  called if a linear FIR filter shall be designed.
 *
 *  \note Originally generated by \e Glade, but heavy modified (see interface.c,
 *        which isn't part of the project).
 *
 *  \param topWidget    Toplevel widget.
 *  \param boxDesignDlg GtkVBox widget, which is the container for the dialog.
 *                      The dialog must be mapped to row 1 of it.
 *  \param pPrefs       Pointer to desktop preferences.
 *
 ******************************************************************************/
    void linFirDesignDlgCreate (GtkWidget *topWidget, GtkWidget *boxDesignDlg,
                                const CFG_DESKTOP* pPrefs);


/* FUNCTION *******************************************************************/
/** Linear FIR filter design dialog preset function. Restores all states
 *  of dialog elements from design data of a linear FIR filter.
 *
 *  \param topWidget    Toplevel widget.
 *  \param pDesign      Pointer to linear FIR design data.
 *  \param pFilter      Pointer to filter coefficients (only member \a f0 used
 *                      as input).
 *  \param pPrefs       Pointer to desktop preferences.
 *
 ******************************************************************************/
    void linFirDesignDlgPreset (GtkWidget *topWidget, const LINFIR_DESIGN *pDesign,
                                const FLTCOEFF *pFilter, const CFG_DESKTOP* pPrefs);



/* FUNCTION *******************************************************************/
/** Linear FIR filter design dialog destroy function.
 *
 *  \note If the dialog is not active the function does nothing.
 *
 *  \param topWidget    Toplevel widget.
 *
 ******************************************************************************/
    void linFirDesignDlgDestroy (GtkWidget *topWidget);


/* FUNCTION *******************************************************************/
/** Linear FIR filter design dialog ready/apply function.
 *
 *  \param topWidget    Toplevel widget.
 *  \param pPrefs       Pointer to desktop preferences.
 *
 *  \return             - 0 (or GSL_SUCCESS) if okay and nothing has changed.
 *                      - a negative number (typically GSL_CONTINUE) if a
 *                        coefficient or the degree has changed, but the filter
 *                        is valid. You can use the FLTERR_WARNING macro from
 *                        filterSupport.h to check this condition.
 *                      - a positive error number (typically from from errno.h
 *                        or gsl_errno.h) that something is wrong and the
 *                        filter must be seen as invalid. You can use the
 *                        FLTERR_CRITICAL macro from filterSupport.h to check
 *                        this condition.
 ******************************************************************************/
    int linFirDesignDlgApply (GtkWidget *topWidget, const CFG_DESKTOP* pPrefs);



/* FUNCTION *******************************************************************/
/** Checks whether the linear FIR filter design dialog is active or not.
 *
 *  \param topWidget    Toplevel widget.
 *
 *  \return             TRUE if the dialog is active (the main-widget of
 *                      linear FIR dialog found), else FALSE.
 ******************************************************************************/
    BOOL linFirDesignDlgActive (GtkWidget *topWidget);


#ifdef  __cplusplus
}
#endif


#endif /* LINFIRDESIGNDLG_H */


/******************************************************************************/
/* END OF FILE                                                                */
/******************************************************************************/
