#!/local/bin/perl

################################################################################
# WWW.ROSS.NET CGI/PERL SCRIPT
# ============================
# Copyright (c) Ross N. Williams 1997. All rights reserved.
#
# This is a page in the Ross N. Williams web at http://www.ross.net/
#
#    Name    : Ross N. Williams.
#    WWW     : http://www.ross.net/
#    Email   : ross@ross.net
#    Phone   : +61 8 8232-6262
#    Fax     : +61 8 8232-6264
#    Snail   : PO Box 3066, Rundle Mall SA 5000, Australia.
#
# This web was created by Ross N. Williams (http://www.ross.net/).
################################################################################


# This number used to protect the hidden directories.
# But nowadays, I use .htaccess protection instead.
$passnumber = "44810328";

# Set up paths.
$dir_ross         = "/web/data/clients/ross";
$dir_confidential = $dir_ross . "/confidential";
$dir_scripts      = $dir_confidential . "/scripts_"   . $passnumber;
$dir_databases    = $dir_confidential . "/databases_" . $passnumber;

$visitors_file = $dir_databases . "/visitors";
$changes_file  = $dir_databases . "/changes.txt";
$quotes_file   = $dir_databases . "/quotes.txt";

@INC = (@INC,$dir_scripts);

require ("lib_assert.pl");
require ("lib_changes.pl");
require ("lib_checkin.pl");
require ("lib_cookie.pl");
require ("lib_country.pl");
require ("lib_datetime.pl");
require ("lib_email.pl");
require ("lib_file.pl");
require ("lib_form.pl");
require ("lib_html.pl");
require ("lib_misc.pl");
require ("lib_path.pl");
require ("lib_protect.pl");
require ("lib_random.pl");
require ("lib_record.pl");
require ("lib_ross.pl");
require ("lib_rv.pl");
require ("lib_search.pl");
require ("lib_semaphore.pl");
require ("lib_string.pl");
require ("lib_trace.pl");
require ("lib_visitors.pl");



&form_parse_and_clean();

$arg_keywords  = $form{"keywords"};
$arg_main      = $form{"main"}      ne '';
$arg_reference = $form{"reference"} ne '';
$arg_tutorial  = $form{"tutorial"}  ne '';
$arg_developer = $form{"developer"}  ne '';

if ($arg_keywords eq '')
  { &html_page('search_e_nokeywords.txt'); }
if ((!$arg_main) && (!$arg_reference) && (!$arg_tutorial) && (!$arg_developer))
  { &html_page('search_e_nomanual.txt'); }

&search_parse_keywords($arg_keywords);
&search_notice_and_or;
&search_zap_stop_words;
$search_blank_target=1;

&html_write_standard_content_header;
&file_echo('search_head.txt');

$arg_keywords_tamed = &html_tame($arg_keywords);
print "<P>Searching for: <B>$arg_keywords_tamed</B><BR>\n";

$page_count = 0;

if ($arg_main)
  {
   print "<P><FONT SIZE=3><B><U>FunnelWeb Main Web</U></B></FONT><BR>";
   @search_dir_required  = ('/web/data/clients/ross/funnelweb');
   @search_dir_excluded  = ('/web/data/clients/ross/funnelweb/');
   @search_file_required = ('.shtml');
   @search_file_excluded = ();
   $search_target='funnelweb';
   $page_count += &search_tree('/web/data/clients/ross/funnelweb',
                               'http://www.ross.net/funnelweb/');
  }

if ($arg_reference)
  {
   print "<P><FONT SIZE=3><B><U>FunnelWeb Reference Manual</U></B></FONT><BR>";
   @search_dir_required  = ('/web/data/clients/ross/funnelweb/reference');
   @search_dir_excluded  = ('');
   @search_file_required = ('.html');
   @search_file_excluded = ();
   $search_target='funnelwebreference';
   $page_count += &search_tree('/web/data/clients/ross/funnelweb/reference',
                               'http://www.ross.net/funnelweb/reference/');
  }

if ($arg_tutorial)
  {
   print "<P><FONT SIZE=3><B><U>FunnelWeb Tutorial Manual</U></B></FONT><BR>";
   @search_dir_required  = ('/web/data/clients/ross/funnelweb/tutorial');
   @search_dir_excluded  = ('');
   @search_file_required = ('.html');
   @search_file_excluded = ();
   $search_target='funnelwebtutorial';
   $page_count += &search_tree('/web/data/clients/ross/funnelweb/tutorial',
                               'http://www.ross.net/funnelweb/tutorial/');
  }

if ($arg_developer)
  {
   print "<P><FONT SIZE=3><B><U>FunnelWeb Developer Manual</U></B></FONT><BR>";
   @search_dir_required  = ('/web/data/clients/ross/funnelweb/developer');
   @search_dir_excluded  = ('');
   @search_file_required = ('.html');
   @search_file_excluded = ();
   $search_target='funnelwebdeveloper';
   $page_count += &search_tree('/web/data/clients/ross/funnelweb/developer',
                               'http://www.ross.net/funnelweb/developer/');
  }

&file_echo('search_tail.txt');

$email_from = "web\@ross.net";
$email_to   = "webmaster\@ross.net";
$email_subj = "FunnelWeb: Someone searched for \"$arg_keywords\".";
&email_open;
&email_line("Someone just performed a FunnelWeb web search:");
&email_line("");
&email_line("   Keywords : $arg_keywords");
$webs_searched = '';
if ($arg_main     ) { $webs_searched .= ' Main'; }
if ($arg_reference) { $webs_searched .= ' Reference'; }
if ($arg_tutorial ) { $webs_searched .= ' Tutorial'; }
if ($arg_developer) { $webs_searched .= ' Developer'; }
&email_line("   Searched :$webs_searched");
&email_line("   Result   : $page_count pages found");
&email_line("   Visitor  : $ENV{'REMOTE_HOST'}");
&email_line("   Referer  : $ENV{'HTTP_REFERER'}");
&email_line("");
&email_line("A FunnelWeb Web");
&email_line("http://www.ross.net/funnelweb/");
&email_close;

exit(0);

