// Code generated by smithy-go-codegen DO NOT EDIT.

package forecast

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/forecast/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Exports a forecast created by the CreateWhatIfForecast operation to your Amazon Simple Storage
// Service (Amazon S3) bucket. The forecast file name will match the following
// conventions:
//
//	≈__
//
// The component is in Java SimpleDateFormat (yyyy-MM-ddTHH-mm-ssZ).
//
// You must specify a DataDestination object that includes an Identity and Access Management
// (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For
// more information, see aws-forecast-iam-roles.
//
// For more information, see howitworks-forecast.
//
// To get a list of all your what-if forecast export jobs, use the ListWhatIfForecastExports operation.
//
// The Status of the forecast export job must be ACTIVE before you can access the
// forecast in your Amazon S3 bucket. To get the status, use the DescribeWhatIfForecastExportoperation.
func (c *Client) CreateWhatIfForecastExport(ctx context.Context, params *CreateWhatIfForecastExportInput, optFns ...func(*Options)) (*CreateWhatIfForecastExportOutput, error) {
	if params == nil {
		params = &CreateWhatIfForecastExportInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateWhatIfForecastExport", params, optFns, c.addOperationCreateWhatIfForecastExportMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateWhatIfForecastExportOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateWhatIfForecastExportInput struct {

	// The location where you want to save the forecast and an Identity and Access
	// Management (IAM) role that Amazon Forecast can assume to access the location.
	// The forecast must be exported to an Amazon S3 bucket.
	//
	// If encryption is used, Destination must include an Key Management Service (KMS)
	// key. The IAM role must allow Amazon Forecast permission to access the key.
	//
	// This member is required.
	Destination *types.DataDestination

	// The list of what-if forecast Amazon Resource Names (ARNs) to export.
	//
	// This member is required.
	WhatIfForecastArns []string

	// The name of the what-if forecast to export.
	//
	// This member is required.
	WhatIfForecastExportName *string

	// The format of the exported data, CSV or PARQUET.
	Format *string

	// A list of [tags] to apply to the what if forecast.
	//
	// [tags]: https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateWhatIfForecastExportOutput struct {

	// The Amazon Resource Name (ARN) of the what-if forecast.
	WhatIfForecastExportArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateWhatIfForecastExportMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateWhatIfForecastExport{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateWhatIfForecastExport{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateWhatIfForecastExport"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateWhatIfForecastExportValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateWhatIfForecastExport(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateWhatIfForecastExport(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateWhatIfForecastExport",
	}
}
