package kubernetesconfiguration

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/kubernetesconfiguration/mgmt/2022-04-02-preview/kubernetesconfiguration"

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BucketDefinition parameters to reconcile to the GitRepository source kind type.
type BucketDefinition struct {
	// URL - The URL to sync for the flux configuration S3 bucket.
	URL *string `json:"url,omitempty"`
	// BucketName - The bucket name to sync from the url endpoint for the flux configuration.
	BucketName *string `json:"bucketName,omitempty"`
	// Insecure - Specify whether to use insecure communication when puling data from the S3 bucket.
	Insecure *bool `json:"insecure,omitempty"`
	// TimeoutInSeconds - The maximum time to attempt to reconcile the cluster git repository source with the remote.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`
	// SyncIntervalInSeconds - The interval at which to re-reconcile the cluster git repository source with the remote.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`
	// AccessKey - Plaintext access key used to securely access the S3 bucket
	AccessKey *string `json:"accessKey,omitempty"`
	// LocalAuthRef - Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
	LocalAuthRef *string `json:"localAuthRef,omitempty"`
}

// BucketPatchDefinition parameters to reconcile to the GitRepository source kind type.
type BucketPatchDefinition struct {
	// URL - The URL to sync for the flux configuration S3 bucket.
	URL *string `json:"url,omitempty"`
	// BucketName - The bucket name to sync from the url endpoint for the flux configuration.
	BucketName *string `json:"bucketName,omitempty"`
	// Insecure - Specify whether to use insecure communication when puling data from the S3 bucket.
	Insecure *bool `json:"insecure,omitempty"`
	// TimeoutInSeconds - The maximum time to attempt to reconcile the cluster git repository source with the remote.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`
	// SyncIntervalInSeconds - The interval at which to re-reconcile the cluster git repository source with the remote.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`
	// AccessKey - Plaintext access key used to securely access the S3 bucket
	AccessKey *string `json:"accessKey,omitempty"`
	// LocalAuthRef - Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
	LocalAuthRef *string `json:"localAuthRef,omitempty"`
}

// ComplianceStatus compliance Status details
type ComplianceStatus struct {
	// ComplianceState - READ-ONLY; The compliance state of the configuration. Possible values include: 'ComplianceStateTypePending', 'ComplianceStateTypeCompliant', 'ComplianceStateTypeNoncompliant', 'ComplianceStateTypeInstalled', 'ComplianceStateTypeFailed'
	ComplianceState ComplianceStateType `json:"complianceState,omitempty"`
	// LastConfigApplied - Datetime the configuration was last applied.
	LastConfigApplied *date.Time `json:"lastConfigApplied,omitempty"`
	// Message - Message from when the configuration was applied.
	Message *string `json:"message,omitempty"`
	// MessageLevel - Level of the message. Possible values include: 'MessageLevelTypeError', 'MessageLevelTypeWarning', 'MessageLevelTypeInformation'
	MessageLevel MessageLevelType `json:"messageLevel,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceStatus.
func (cs ComplianceStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.LastConfigApplied != nil {
		objectMap["lastConfigApplied"] = cs.LastConfigApplied
	}
	if cs.Message != nil {
		objectMap["message"] = cs.Message
	}
	if cs.MessageLevel != "" {
		objectMap["messageLevel"] = cs.MessageLevel
	}
	return json.Marshal(objectMap)
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Extension the Extension object.
type Extension struct {
	autorest.Response `json:"-"`
	// ExtensionProperties - Properties of an Extension resource
	*ExtensionProperties `json:"properties,omitempty"`
	// Identity - Identity of the Extension resource
	Identity *Identity `json:"identity,omitempty"`
	// Plan - The plan information.
	Plan *Plan `json:"plan,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Extension.
func (e Extension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.ExtensionProperties != nil {
		objectMap["properties"] = e.ExtensionProperties
	}
	if e.Identity != nil {
		objectMap["identity"] = e.Identity
	}
	if e.Plan != nil {
		objectMap["plan"] = e.Plan
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Extension struct.
func (e *Extension) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extensionProperties ExtensionProperties
				err = json.Unmarshal(*v, &extensionProperties)
				if err != nil {
					return err
				}
				e.ExtensionProperties = &extensionProperties
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				e.Identity = &identity
			}
		case "plan":
			if v != nil {
				var plan Plan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				e.Plan = &plan
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				e.SystemData = &systemData
			}
		}
	}

	return nil
}

// ExtensionProperties properties of an Extension resource
type ExtensionProperties struct {
	// ExtensionType - Type of the Extension, of which this resource is an instance of.  It must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the Extension publisher.
	ExtensionType *string `json:"extensionType,omitempty"`
	// AutoUpgradeMinorVersion - Flag to note if this extension participates in auto upgrade of minor version, or not.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// ReleaseTrain - ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
	ReleaseTrain *string `json:"releaseTrain,omitempty"`
	// Version - User-specified version of the extension for this extension to 'pin'. To use 'version', autoUpgradeMinorVersion must be 'false'.
	Version *string `json:"version,omitempty"`
	// Scope - Scope at which the extension is installed.
	Scope *Scope `json:"scope,omitempty"`
	// ConfigurationSettings - Configuration settings, as name-value pairs for configuring this extension.
	ConfigurationSettings map[string]*string `json:"configurationSettings"`
	// ConfigurationProtectedSettings - Configuration settings that are sensitive, as name-value pairs for configuring this extension.
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings"`
	// InstalledVersion - READ-ONLY; Installed version of the extension.
	InstalledVersion *string `json:"installedVersion,omitempty"`
	// ProvisioningState - READ-ONLY; Status of installation of this extension. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Statuses - Status from this extension.
	Statuses *[]ExtensionStatus `json:"statuses,omitempty"`
	// ErrorInfo - READ-ONLY; Error information from the Agent - e.g. errors during installation.
	ErrorInfo *ErrorDetail `json:"errorInfo,omitempty"`
	// CustomLocationSettings - READ-ONLY; Custom Location settings properties.
	CustomLocationSettings map[string]*string `json:"customLocationSettings"`
	// PackageURI - READ-ONLY; Uri of the Helm package
	PackageURI *string `json:"packageUri,omitempty"`
	// AksAssignedIdentity - Identity of the Extension resource in an AKS cluster
	AksAssignedIdentity *ExtensionPropertiesAksAssignedIdentity `json:"aksAssignedIdentity,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionProperties.
func (e ExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.ExtensionType != nil {
		objectMap["extensionType"] = e.ExtensionType
	}
	if e.AutoUpgradeMinorVersion != nil {
		objectMap["autoUpgradeMinorVersion"] = e.AutoUpgradeMinorVersion
	}
	if e.ReleaseTrain != nil {
		objectMap["releaseTrain"] = e.ReleaseTrain
	}
	if e.Version != nil {
		objectMap["version"] = e.Version
	}
	if e.Scope != nil {
		objectMap["scope"] = e.Scope
	}
	if e.ConfigurationSettings != nil {
		objectMap["configurationSettings"] = e.ConfigurationSettings
	}
	if e.ConfigurationProtectedSettings != nil {
		objectMap["configurationProtectedSettings"] = e.ConfigurationProtectedSettings
	}
	if e.Statuses != nil {
		objectMap["statuses"] = e.Statuses
	}
	if e.AksAssignedIdentity != nil {
		objectMap["aksAssignedIdentity"] = e.AksAssignedIdentity
	}
	return json.Marshal(objectMap)
}

// ExtensionPropertiesAksAssignedIdentity identity of the Extension resource in an AKS cluster
type ExtensionPropertiesAksAssignedIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'AKSIdentityTypeSystemAssigned', 'AKSIdentityTypeUserAssigned'
	Type AKSIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionPropertiesAksAssignedIdentity.
func (eAi ExtensionPropertiesAksAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eAi.Type != "" {
		objectMap["type"] = eAi.Type
	}
	return json.Marshal(objectMap)
}

// ExtensionsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (Extension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsCreateFuture.Result.
func (future *ExtensionsCreateFuture) result(client ExtensionsClient) (e Extension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.ExtensionsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.ExtensionsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.CreateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kubernetesconfiguration.ExtensionsCreateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExtensionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsDeleteFuture.Result.
func (future *ExtensionsDeleteFuture) result(client ExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.ExtensionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.ExtensionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExtensionsList result of the request to list Extensions.  It contains a list of Extension objects and a
// URL link to get the next set of results.
type ExtensionsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Extensions within a Kubernetes cluster.
	Value *[]Extension `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of extension objects, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionsList.
func (el ExtensionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExtensionsListIterator provides access to a complete listing of Extension values.
type ExtensionsListIterator struct {
	i    int
	page ExtensionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtensionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtensionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtensionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtensionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtensionsListIterator) Response() ExtensionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtensionsListIterator) Value() Extension {
	if !iter.page.NotDone() {
		return Extension{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtensionsListIterator type.
func NewExtensionsListIterator(page ExtensionsListPage) ExtensionsListIterator {
	return ExtensionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (el ExtensionsList) IsEmpty() bool {
	return el.Value == nil || len(*el.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (el ExtensionsList) hasNextLink() bool {
	return el.NextLink != nil && len(*el.NextLink) != 0
}

// extensionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (el ExtensionsList) extensionsListPreparer(ctx context.Context) (*http.Request, error) {
	if !el.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(el.NextLink)))
}

// ExtensionsListPage contains a page of Extension values.
type ExtensionsListPage struct {
	fn func(context.Context, ExtensionsList) (ExtensionsList, error)
	el ExtensionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtensionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtensionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.el)
		if err != nil {
			return err
		}
		page.el = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtensionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtensionsListPage) NotDone() bool {
	return !page.el.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtensionsListPage) Response() ExtensionsList {
	return page.el
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtensionsListPage) Values() []Extension {
	if page.el.IsEmpty() {
		return nil
	}
	return *page.el.Value
}

// Creates a new instance of the ExtensionsListPage type.
func NewExtensionsListPage(cur ExtensionsList, getNextPage func(context.Context, ExtensionsList) (ExtensionsList, error)) ExtensionsListPage {
	return ExtensionsListPage{
		fn: getNextPage,
		el: cur,
	}
}

// ExtensionStatus status from the extension.
type ExtensionStatus struct {
	// Code - Status code provided by the Extension
	Code *string `json:"code,omitempty"`
	// DisplayStatus - Short description of status of the extension.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Level - Level of the status. Possible values include: 'LevelTypeError', 'LevelTypeWarning', 'LevelTypeInformation'
	Level LevelType `json:"level,omitempty"`
	// Message - Detailed message of the status from the Extension.
	Message *string `json:"message,omitempty"`
	// Time - DateLiteral (per ISO8601) noting the time of installation status.
	Time *string `json:"time,omitempty"`
}

// ExtensionsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (Extension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsUpdateFuture.Result.
func (future *ExtensionsUpdateFuture) result(client ExtensionsClient) (e Extension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.ExtensionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.ExtensionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.UpdateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kubernetesconfiguration.ExtensionsUpdateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FluxConfiguration the Flux Configuration object returned in Get & Put response.
type FluxConfiguration struct {
	autorest.Response `json:"-"`
	// FluxConfigurationProperties - Properties to create a Flux Configuration resource
	*FluxConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for FluxConfiguration.
func (fc FluxConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fc.FluxConfigurationProperties != nil {
		objectMap["properties"] = fc.FluxConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FluxConfiguration struct.
func (fc *FluxConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fluxConfigurationProperties FluxConfigurationProperties
				err = json.Unmarshal(*v, &fluxConfigurationProperties)
				if err != nil {
					return err
				}
				fc.FluxConfigurationProperties = &fluxConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				fc.SystemData = &systemData
			}
		}
	}

	return nil
}

// FluxConfigurationPatch the Flux Configuration Patch Request object.
type FluxConfigurationPatch struct {
	// FluxConfigurationPatchProperties - Updatable properties of an Flux Configuration Patch Request
	*FluxConfigurationPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for FluxConfigurationPatch.
func (fcp FluxConfigurationPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fcp.FluxConfigurationPatchProperties != nil {
		objectMap["properties"] = fcp.FluxConfigurationPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FluxConfigurationPatch struct.
func (fcp *FluxConfigurationPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fluxConfigurationPatchProperties FluxConfigurationPatchProperties
				err = json.Unmarshal(*v, &fluxConfigurationPatchProperties)
				if err != nil {
					return err
				}
				fcp.FluxConfigurationPatchProperties = &fluxConfigurationPatchProperties
			}
		}
	}

	return nil
}

// FluxConfigurationPatchProperties updatable properties of an Flux Configuration Patch Request
type FluxConfigurationPatchProperties struct {
	// SourceKind - Source Kind to pull the configuration data from. Possible values include: 'SourceKindTypeGitRepository', 'SourceKindTypeBucket'
	SourceKind SourceKindType `json:"sourceKind,omitempty"`
	// Suspend - Whether this configuration should suspend its reconciliation of its kustomizations and sources.
	Suspend *bool `json:"suspend,omitempty"`
	// GitRepository - Parameters to reconcile to the GitRepository source kind type.
	GitRepository *GitRepositoryPatchDefinition `json:"gitRepository,omitempty"`
	// Bucket - Parameters to reconcile to the Bucket source kind type.
	Bucket *BucketPatchDefinition `json:"bucket,omitempty"`
	// Kustomizations - Array of kustomizations used to reconcile the artifact pulled by the source type on the cluster.
	Kustomizations map[string]*KustomizationPatchDefinition `json:"kustomizations"`
	// ConfigurationProtectedSettings - Key-value pairs of protected configuration settings for the configuration
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings"`
}

// MarshalJSON is the custom marshaler for FluxConfigurationPatchProperties.
func (fcp FluxConfigurationPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fcp.SourceKind != "" {
		objectMap["sourceKind"] = fcp.SourceKind
	}
	if fcp.Suspend != nil {
		objectMap["suspend"] = fcp.Suspend
	}
	if fcp.GitRepository != nil {
		objectMap["gitRepository"] = fcp.GitRepository
	}
	if fcp.Bucket != nil {
		objectMap["bucket"] = fcp.Bucket
	}
	if fcp.Kustomizations != nil {
		objectMap["kustomizations"] = fcp.Kustomizations
	}
	if fcp.ConfigurationProtectedSettings != nil {
		objectMap["configurationProtectedSettings"] = fcp.ConfigurationProtectedSettings
	}
	return json.Marshal(objectMap)
}

// FluxConfigurationProperties properties to create a Flux Configuration resource
type FluxConfigurationProperties struct {
	// Scope - Scope at which the operator will be installed. Possible values include: 'ScopeTypeCluster', 'ScopeTypeNamespace'
	Scope ScopeType `json:"scope,omitempty"`
	// Namespace - The namespace to which this configuration is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
	Namespace *string `json:"namespace,omitempty"`
	// SourceKind - Source Kind to pull the configuration data from. Possible values include: 'SourceKindTypeGitRepository', 'SourceKindTypeBucket'
	SourceKind SourceKindType `json:"sourceKind,omitempty"`
	// Suspend - Whether this configuration should suspend its reconciliation of its kustomizations and sources.
	Suspend *bool `json:"suspend,omitempty"`
	// GitRepository - Parameters to reconcile to the GitRepository source kind type.
	GitRepository *GitRepositoryDefinition `json:"gitRepository,omitempty"`
	// Bucket - Parameters to reconcile to the Bucket source kind type.
	Bucket *BucketDefinition `json:"bucket,omitempty"`
	// Kustomizations - Array of kustomizations used to reconcile the artifact pulled by the source type on the cluster.
	Kustomizations map[string]*KustomizationDefinition `json:"kustomizations"`
	// ConfigurationProtectedSettings - Key-value pairs of protected configuration settings for the configuration
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings"`
	// Statuses - READ-ONLY; Statuses of the Flux Kubernetes resources created by the fluxConfiguration or created by the managed objects provisioned by the fluxConfiguration.
	Statuses *[]ObjectStatusDefinition `json:"statuses,omitempty"`
	// RepositoryPublicKey - READ-ONLY; Public Key associated with this fluxConfiguration (either generated within the cluster or provided by the user).
	RepositoryPublicKey *string `json:"repositoryPublicKey,omitempty"`
	// SourceSyncedCommitID - READ-ONLY; Branch and/or SHA of the source commit synced with the cluster.
	SourceSyncedCommitID *string `json:"sourceSyncedCommitId,omitempty"`
	// SourceUpdatedAt - READ-ONLY; Datetime the fluxConfiguration synced its source on the cluster.
	SourceUpdatedAt *date.Time `json:"sourceUpdatedAt,omitempty"`
	// StatusUpdatedAt - READ-ONLY; Datetime the fluxConfiguration synced its status on the cluster with Azure.
	StatusUpdatedAt *date.Time `json:"statusUpdatedAt,omitempty"`
	// ComplianceState - READ-ONLY; Combined status of the Flux Kubernetes resources created by the fluxConfiguration or created by the managed objects. Possible values include: 'FluxComplianceStateCompliant', 'FluxComplianceStateNonCompliant', 'FluxComplianceStatePending', 'FluxComplianceStateSuspended', 'FluxComplianceStateUnknown'
	ComplianceState FluxComplianceState `json:"complianceState,omitempty"`
	// ProvisioningState - READ-ONLY; Status of the creation of the fluxConfiguration. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ErrorMessage - READ-ONLY; Error message returned to the user in the case of provisioning failure.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for FluxConfigurationProperties.
func (fc FluxConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fc.Scope != "" {
		objectMap["scope"] = fc.Scope
	}
	if fc.Namespace != nil {
		objectMap["namespace"] = fc.Namespace
	}
	if fc.SourceKind != "" {
		objectMap["sourceKind"] = fc.SourceKind
	}
	if fc.Suspend != nil {
		objectMap["suspend"] = fc.Suspend
	}
	if fc.GitRepository != nil {
		objectMap["gitRepository"] = fc.GitRepository
	}
	if fc.Bucket != nil {
		objectMap["bucket"] = fc.Bucket
	}
	if fc.Kustomizations != nil {
		objectMap["kustomizations"] = fc.Kustomizations
	}
	if fc.ConfigurationProtectedSettings != nil {
		objectMap["configurationProtectedSettings"] = fc.ConfigurationProtectedSettings
	}
	return json.Marshal(objectMap)
}

// FluxConfigurationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FluxConfigurationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FluxConfigurationsClient) (FluxConfiguration, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FluxConfigurationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FluxConfigurationsCreateOrUpdateFuture.Result.
func (future *FluxConfigurationsCreateOrUpdateFuture) result(client FluxConfigurationsClient) (fc FluxConfiguration, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.FluxConfigurationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.FluxConfigurationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fc.Response.Response, err = future.GetResult(sender); err == nil && fc.Response.Response.StatusCode != http.StatusNoContent {
		fc, err = client.CreateOrUpdateResponder(fc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kubernetesconfiguration.FluxConfigurationsCreateOrUpdateFuture", "Result", fc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FluxConfigurationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FluxConfigurationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FluxConfigurationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FluxConfigurationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FluxConfigurationsDeleteFuture.Result.
func (future *FluxConfigurationsDeleteFuture) result(client FluxConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.FluxConfigurationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.FluxConfigurationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FluxConfigurationsList result of the request to list Flux Configurations.  It contains a list of
// FluxConfiguration objects and a URL link to get the next set of results.
type FluxConfigurationsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Flux Configurations within a Kubernetes cluster.
	Value *[]FluxConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of configuration objects, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for FluxConfigurationsList.
func (fcl FluxConfigurationsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FluxConfigurationsListIterator provides access to a complete listing of FluxConfiguration values.
type FluxConfigurationsListIterator struct {
	i    int
	page FluxConfigurationsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FluxConfigurationsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FluxConfigurationsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FluxConfigurationsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FluxConfigurationsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FluxConfigurationsListIterator) Response() FluxConfigurationsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FluxConfigurationsListIterator) Value() FluxConfiguration {
	if !iter.page.NotDone() {
		return FluxConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FluxConfigurationsListIterator type.
func NewFluxConfigurationsListIterator(page FluxConfigurationsListPage) FluxConfigurationsListIterator {
	return FluxConfigurationsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fcl FluxConfigurationsList) IsEmpty() bool {
	return fcl.Value == nil || len(*fcl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fcl FluxConfigurationsList) hasNextLink() bool {
	return fcl.NextLink != nil && len(*fcl.NextLink) != 0
}

// fluxConfigurationsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fcl FluxConfigurationsList) fluxConfigurationsListPreparer(ctx context.Context) (*http.Request, error) {
	if !fcl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fcl.NextLink)))
}

// FluxConfigurationsListPage contains a page of FluxConfiguration values.
type FluxConfigurationsListPage struct {
	fn  func(context.Context, FluxConfigurationsList) (FluxConfigurationsList, error)
	fcl FluxConfigurationsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FluxConfigurationsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FluxConfigurationsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fcl)
		if err != nil {
			return err
		}
		page.fcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FluxConfigurationsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FluxConfigurationsListPage) NotDone() bool {
	return !page.fcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FluxConfigurationsListPage) Response() FluxConfigurationsList {
	return page.fcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FluxConfigurationsListPage) Values() []FluxConfiguration {
	if page.fcl.IsEmpty() {
		return nil
	}
	return *page.fcl.Value
}

// Creates a new instance of the FluxConfigurationsListPage type.
func NewFluxConfigurationsListPage(cur FluxConfigurationsList, getNextPage func(context.Context, FluxConfigurationsList) (FluxConfigurationsList, error)) FluxConfigurationsListPage {
	return FluxConfigurationsListPage{
		fn:  getNextPage,
		fcl: cur,
	}
}

// FluxConfigurationsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FluxConfigurationsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FluxConfigurationsClient) (FluxConfiguration, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FluxConfigurationsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FluxConfigurationsUpdateFuture.Result.
func (future *FluxConfigurationsUpdateFuture) result(client FluxConfigurationsClient) (fc FluxConfiguration, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.FluxConfigurationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.FluxConfigurationsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fc.Response.Response, err = future.GetResult(sender); err == nil && fc.Response.Response.StatusCode != http.StatusNoContent {
		fc, err = client.UpdateResponder(fc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kubernetesconfiguration.FluxConfigurationsUpdateFuture", "Result", fc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GitRepositoryDefinition parameters to reconcile to the GitRepository source kind type.
type GitRepositoryDefinition struct {
	// URL - The URL to sync for the flux configuration git repository.
	URL *string `json:"url,omitempty"`
	// TimeoutInSeconds - The maximum time to attempt to reconcile the cluster git repository source with the remote.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`
	// SyncIntervalInSeconds - The interval at which to re-reconcile the cluster git repository source with the remote.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`
	// RepositoryRef - The source reference for the GitRepository object.
	RepositoryRef *RepositoryRefDefinition `json:"repositoryRef,omitempty"`
	// SSHKnownHosts - Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
	SSHKnownHosts *string `json:"sshKnownHosts,omitempty"`
	// HTTPSUser - Plaintext HTTPS username used to access private git repositories over HTTPS
	HTTPSUser *string `json:"httpsUser,omitempty"`
	// HTTPSCACert - Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
	HTTPSCACert *string `json:"httpsCACert,omitempty"`
	// LocalAuthRef - Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
	LocalAuthRef *string `json:"localAuthRef,omitempty"`
}

// GitRepositoryPatchDefinition parameters to reconcile to the GitRepository source kind type.
type GitRepositoryPatchDefinition struct {
	// URL - The URL to sync for the flux configuration git repository.
	URL *string `json:"url,omitempty"`
	// TimeoutInSeconds - The maximum time to attempt to reconcile the cluster git repository source with the remote.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`
	// SyncIntervalInSeconds - The interval at which to re-reconcile the cluster git repository source with the remote.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`
	// RepositoryRef - The source reference for the GitRepository object.
	RepositoryRef *RepositoryRefDefinition `json:"repositoryRef,omitempty"`
	// SSHKnownHosts - Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
	SSHKnownHosts *string `json:"sshKnownHosts,omitempty"`
	// HTTPSUser - Plaintext HTTPS username used to access private git repositories over HTTPS
	HTTPSUser *string `json:"httpsUser,omitempty"`
	// HTTPSCACert - Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
	HTTPSCACert *string `json:"httpsCACert,omitempty"`
	// LocalAuthRef - Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
	LocalAuthRef *string `json:"localAuthRef,omitempty"`
}

// HelmOperatorProperties properties for Helm operator.
type HelmOperatorProperties struct {
	// ChartVersion - Version of the operator Helm chart.
	ChartVersion *string `json:"chartVersion,omitempty"`
	// ChartValues - Values override for the operator Helm chart.
	ChartValues *string `json:"chartValues,omitempty"`
}

// HelmReleasePropertiesDefinition properties for HelmRelease objects
type HelmReleasePropertiesDefinition struct {
	// LastRevisionApplied - The revision number of the last released object change
	LastRevisionApplied *int64 `json:"lastRevisionApplied,omitempty"`
	// HelmChartRef - The reference to the HelmChart object used as the source to this HelmRelease
	HelmChartRef *ObjectReferenceDefinition `json:"helmChartRef,omitempty"`
	// FailureCount - Total number of times that the HelmRelease failed to install or upgrade
	FailureCount *int64 `json:"failureCount,omitempty"`
	// InstallFailureCount - Number of times that the HelmRelease failed to install
	InstallFailureCount *int64 `json:"installFailureCount,omitempty"`
	// UpgradeFailureCount - Number of times that the HelmRelease failed to upgrade
	UpgradeFailureCount *int64 `json:"upgradeFailureCount,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// KustomizationDefinition the Kustomization defining how to reconcile the artifact pulled by the source
// type on the cluster.
type KustomizationDefinition struct {
	// Name - READ-ONLY; Name of the Kustomization, matching the key in the Kustomizations object map.
	Name *string `json:"name,omitempty"`
	// Path - The path in the source reference to reconcile on the cluster.
	Path *string `json:"path,omitempty"`
	// DependsOn - Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
	DependsOn *[]string `json:"dependsOn,omitempty"`
	// TimeoutInSeconds - The maximum time to attempt to reconcile the Kustomization on the cluster.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`
	// SyncIntervalInSeconds - The interval at which to re-reconcile the Kustomization on the cluster.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`
	// RetryIntervalInSeconds - The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
	RetryIntervalInSeconds *int64 `json:"retryIntervalInSeconds,omitempty"`
	// Prune - Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
	Prune *bool `json:"prune,omitempty"`
	// Force - Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
	Force *bool `json:"force,omitempty"`
}

// MarshalJSON is the custom marshaler for KustomizationDefinition.
func (kd KustomizationDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kd.Path != nil {
		objectMap["path"] = kd.Path
	}
	if kd.DependsOn != nil {
		objectMap["dependsOn"] = kd.DependsOn
	}
	if kd.TimeoutInSeconds != nil {
		objectMap["timeoutInSeconds"] = kd.TimeoutInSeconds
	}
	if kd.SyncIntervalInSeconds != nil {
		objectMap["syncIntervalInSeconds"] = kd.SyncIntervalInSeconds
	}
	if kd.RetryIntervalInSeconds != nil {
		objectMap["retryIntervalInSeconds"] = kd.RetryIntervalInSeconds
	}
	if kd.Prune != nil {
		objectMap["prune"] = kd.Prune
	}
	if kd.Force != nil {
		objectMap["force"] = kd.Force
	}
	return json.Marshal(objectMap)
}

// KustomizationPatchDefinition the Kustomization defining how to reconcile the artifact pulled by the
// source type on the cluster.
type KustomizationPatchDefinition struct {
	// Path - The path in the source reference to reconcile on the cluster.
	Path *string `json:"path,omitempty"`
	// DependsOn - Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
	DependsOn *[]string `json:"dependsOn,omitempty"`
	// TimeoutInSeconds - The maximum time to attempt to reconcile the Kustomization on the cluster.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`
	// SyncIntervalInSeconds - The interval at which to re-reconcile the Kustomization on the cluster.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`
	// RetryIntervalInSeconds - The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
	RetryIntervalInSeconds *int64 `json:"retryIntervalInSeconds,omitempty"`
	// Prune - Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
	Prune *bool `json:"prune,omitempty"`
	// Force - Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
	Force *bool `json:"force,omitempty"`
}

// ObjectReferenceDefinition object reference to a Kubernetes object on a cluster
type ObjectReferenceDefinition struct {
	// Name - Name of the object
	Name *string `json:"name,omitempty"`
	// Namespace - Namespace of the object
	Namespace *string `json:"namespace,omitempty"`
}

// ObjectStatusConditionDefinition status condition of Kubernetes object
type ObjectStatusConditionDefinition struct {
	// LastTransitionTime - Last time this status condition has changed
	LastTransitionTime *date.Time `json:"lastTransitionTime,omitempty"`
	// Message - A more verbose description of the object status condition
	Message *string `json:"message,omitempty"`
	// Reason - Reason for the specified status condition type status
	Reason *string `json:"reason,omitempty"`
	// Status - Status of the Kubernetes object condition type
	Status *string `json:"status,omitempty"`
	// Type - Object status condition type for this object
	Type *string `json:"type,omitempty"`
}

// ObjectStatusDefinition statuses of objects deployed by the user-specified kustomizations from the git
// repository.
type ObjectStatusDefinition struct {
	// Name - Name of the applied object
	Name *string `json:"name,omitempty"`
	// Namespace - Namespace of the applied object
	Namespace *string `json:"namespace,omitempty"`
	// Kind - Kind of the applied object
	Kind *string `json:"kind,omitempty"`
	// ComplianceState - Compliance state of the applied object showing whether the applied object has come into a ready state on the cluster. Possible values include: 'FluxComplianceStateCompliant', 'FluxComplianceStateNonCompliant', 'FluxComplianceStatePending', 'FluxComplianceStateSuspended', 'FluxComplianceStateUnknown'
	ComplianceState FluxComplianceState `json:"complianceState,omitempty"`
	// AppliedBy - Object reference to the Kustomization that applied this object
	AppliedBy *ObjectReferenceDefinition `json:"appliedBy,omitempty"`
	// StatusConditions - List of Kubernetes object status conditions present on the cluster
	StatusConditions *[]ObjectStatusConditionDefinition `json:"statusConditions,omitempty"`
	// HelmReleaseProperties - Additional properties that are provided from objects of the HelmRelease kind
	HelmReleaseProperties *HelmReleasePropertiesDefinition `json:"helmReleaseProperties,omitempty"`
}

// OperationStatusList the async operations in progress, in the cluster.
type OperationStatusList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of async operations in progress, in the cluster.
	Value *[]OperationStatusResult `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of Operation Result objects, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusList.
func (osl OperationStatusList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationStatusListIterator provides access to a complete listing of OperationStatusResult values.
type OperationStatusListIterator struct {
	i    int
	page OperationStatusListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationStatusListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationStatusListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationStatusListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationStatusListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationStatusListIterator) Response() OperationStatusList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationStatusListIterator) Value() OperationStatusResult {
	if !iter.page.NotDone() {
		return OperationStatusResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationStatusListIterator type.
func NewOperationStatusListIterator(page OperationStatusListPage) OperationStatusListIterator {
	return OperationStatusListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (osl OperationStatusList) IsEmpty() bool {
	return osl.Value == nil || len(*osl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (osl OperationStatusList) hasNextLink() bool {
	return osl.NextLink != nil && len(*osl.NextLink) != 0
}

// operationStatusListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (osl OperationStatusList) operationStatusListPreparer(ctx context.Context) (*http.Request, error) {
	if !osl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(osl.NextLink)))
}

// OperationStatusListPage contains a page of OperationStatusResult values.
type OperationStatusListPage struct {
	fn  func(context.Context, OperationStatusList) (OperationStatusList, error)
	osl OperationStatusList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationStatusListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationStatusListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.osl)
		if err != nil {
			return err
		}
		page.osl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationStatusListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationStatusListPage) NotDone() bool {
	return !page.osl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationStatusListPage) Response() OperationStatusList {
	return page.osl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationStatusListPage) Values() []OperationStatusResult {
	if page.osl.IsEmpty() {
		return nil
	}
	return *page.osl.Value
}

// Creates a new instance of the OperationStatusListPage type.
func NewOperationStatusListPage(cur OperationStatusList, getNextPage func(context.Context, OperationStatusList) (OperationStatusList, error)) OperationStatusListPage {
	return OperationStatusListPage{
		fn:  getNextPage,
		osl: cur,
	}
}

// OperationStatusResult the current status of an async operation.
type OperationStatusResult struct {
	autorest.Response `json:"-"`
	// ID - Fully qualified ID for the async operation.
	ID *string `json:"id,omitempty"`
	// Name - Name of the async operation.
	Name *string `json:"name,omitempty"`
	// Status - Operation status.
	Status *string `json:"status,omitempty"`
	// Properties - Additional information, if available.
	Properties map[string]*string `json:"properties"`
	// Error - READ-ONLY; If present, details of the operation error.
	Error *ErrorDetail `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusResult.
func (osr OperationStatusResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if osr.ID != nil {
		objectMap["id"] = osr.ID
	}
	if osr.Name != nil {
		objectMap["name"] = osr.Name
	}
	if osr.Status != nil {
		objectMap["status"] = osr.Status
	}
	if osr.Properties != nil {
		objectMap["properties"] = osr.Properties
	}
	return json.Marshal(objectMap)
}

// PatchExtension the Extension Patch Request object.
type PatchExtension struct {
	// PatchExtensionProperties - Updatable properties of an Extension Patch Request
	*PatchExtensionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchExtension.
func (peVar PatchExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if peVar.PatchExtensionProperties != nil {
		objectMap["properties"] = peVar.PatchExtensionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PatchExtension struct.
func (peVar *PatchExtension) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var patchExtensionProperties PatchExtensionProperties
				err = json.Unmarshal(*v, &patchExtensionProperties)
				if err != nil {
					return err
				}
				peVar.PatchExtensionProperties = &patchExtensionProperties
			}
		}
	}

	return nil
}

// PatchExtensionProperties updatable properties of an Extension Patch Request
type PatchExtensionProperties struct {
	// AutoUpgradeMinorVersion - Flag to note if this extension participates in auto upgrade of minor version, or not.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// ReleaseTrain - ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
	ReleaseTrain *string `json:"releaseTrain,omitempty"`
	// Version - Version of the extension for this extension, if it is 'pinned' to a specific version. autoUpgradeMinorVersion must be 'false'.
	Version *string `json:"version,omitempty"`
	// ConfigurationSettings - Configuration settings, as name-value pairs for configuring this extension.
	ConfigurationSettings map[string]*string `json:"configurationSettings"`
	// ConfigurationProtectedSettings - Configuration settings that are sensitive, as name-value pairs for configuring this extension.
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings"`
}

// MarshalJSON is the custom marshaler for PatchExtensionProperties.
func (peVar PatchExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if peVar.AutoUpgradeMinorVersion != nil {
		objectMap["autoUpgradeMinorVersion"] = peVar.AutoUpgradeMinorVersion
	}
	if peVar.ReleaseTrain != nil {
		objectMap["releaseTrain"] = peVar.ReleaseTrain
	}
	if peVar.Version != nil {
		objectMap["version"] = peVar.Version
	}
	if peVar.ConfigurationSettings != nil {
		objectMap["configurationSettings"] = peVar.ConfigurationSettings
	}
	if peVar.ConfigurationProtectedSettings != nil {
		objectMap["configurationProtectedSettings"] = peVar.ConfigurationProtectedSettings
	}
	return json.Marshal(objectMap)
}

// Plan plan for the resource.
type Plan struct {
	// Name - A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`
	// Product - The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`
	// PromotionCode - A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pec.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult list of private endpoint connection associated with the specified
// storage account
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kubernetesconfiguration.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				plr.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkScope an Azure Arc PrivateLinkScope definition.
type PrivateLinkScope struct {
	autorest.Response `json:"-"`
	// Properties - Properties that define a Azure Arc PrivateLinkScope resource.
	Properties *PrivateLinkScopeProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkScope.
func (pls PrivateLinkScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pls.Properties != nil {
		objectMap["properties"] = pls.Properties
	}
	if pls.Tags != nil {
		objectMap["tags"] = pls.Tags
	}
	if pls.Location != nil {
		objectMap["location"] = pls.Location
	}
	return json.Marshal(objectMap)
}

// PrivateLinkScopeListResult describes the list of Azure Arc PrivateLinkScope resources.
type PrivateLinkScopeListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Azure Arc PrivateLinkScope definitions.
	Value *[]PrivateLinkScope `json:"value,omitempty"`
	// NextLink - The URI to get the next set of Azure Arc PrivateLinkScope definitions if too many PrivateLinkScopes where returned in the result set.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateLinkScopeListResultIterator provides access to a complete listing of PrivateLinkScope values.
type PrivateLinkScopeListResultIterator struct {
	i    int
	page PrivateLinkScopeListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkScopeListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkScopeListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkScopeListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkScopeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkScopeListResultIterator) Response() PrivateLinkScopeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkScopeListResultIterator) Value() PrivateLinkScope {
	if !iter.page.NotDone() {
		return PrivateLinkScope{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkScopeListResultIterator type.
func NewPrivateLinkScopeListResultIterator(page PrivateLinkScopeListResultPage) PrivateLinkScopeListResultIterator {
	return PrivateLinkScopeListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plslr PrivateLinkScopeListResult) IsEmpty() bool {
	return plslr.Value == nil || len(*plslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plslr PrivateLinkScopeListResult) hasNextLink() bool {
	return plslr.NextLink != nil && len(*plslr.NextLink) != 0
}

// privateLinkScopeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plslr PrivateLinkScopeListResult) privateLinkScopeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plslr.NextLink)))
}

// PrivateLinkScopeListResultPage contains a page of PrivateLinkScope values.
type PrivateLinkScopeListResultPage struct {
	fn    func(context.Context, PrivateLinkScopeListResult) (PrivateLinkScopeListResult, error)
	plslr PrivateLinkScopeListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkScopeListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkScopeListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plslr)
		if err != nil {
			return err
		}
		page.plslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkScopeListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkScopeListResultPage) NotDone() bool {
	return !page.plslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkScopeListResultPage) Response() PrivateLinkScopeListResult {
	return page.plslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkScopeListResultPage) Values() []PrivateLinkScope {
	if page.plslr.IsEmpty() {
		return nil
	}
	return *page.plslr.Value
}

// Creates a new instance of the PrivateLinkScopeListResultPage type.
func NewPrivateLinkScopeListResultPage(cur PrivateLinkScopeListResult, getNextPage func(context.Context, PrivateLinkScopeListResult) (PrivateLinkScopeListResult, error)) PrivateLinkScopeListResultPage {
	return PrivateLinkScopeListResultPage{
		fn:    getNextPage,
		plslr: cur,
	}
}

// PrivateLinkScopeProperties properties that define a Azure Arc PrivateLinkScope resource.
type PrivateLinkScopeProperties struct {
	// PublicNetworkAccess - Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints. Possible values include: 'PublicNetworkAccessTypeEnabled', 'PublicNetworkAccessTypeDisabled'
	PublicNetworkAccess PublicNetworkAccessType `json:"publicNetworkAccess,omitempty"`
	// ProvisioningState - READ-ONLY; Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ClusterResourceID - Managed Cluster ARM ID for the private link scope  (Required)
	ClusterResourceID *string `json:"clusterResourceId,omitempty"`
	// PrivateLinkScopeID - READ-ONLY; The Guid id of the private link scope.
	PrivateLinkScopeID *string `json:"privateLinkScopeId,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; The collection of associated Private Endpoint Connections.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkScopeProperties.
func (plsp PrivateLinkScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plsp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = plsp.PublicNetworkAccess
	}
	if plsp.ClusterResourceID != nil {
		objectMap["clusterResourceId"] = plsp.ClusterResourceID
	}
	return json.Marshal(objectMap)
}

// PrivateLinkScopesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateLinkScopesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkScopesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateLinkScopesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateLinkScopesDeleteFuture.Result.
func (future *PrivateLinkScopesDeleteFuture) result(client PrivateLinkScopesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.PrivateLinkScopesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.PrivateLinkScopesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RepositoryRefDefinition the source reference for the GitRepository object.
type RepositoryRefDefinition struct {
	// Branch - The git repository branch name to checkout.
	Branch *string `json:"branch,omitempty"`
	// Tag - The git repository tag name to checkout. This takes precedence over branch.
	Tag *string `json:"tag,omitempty"`
	// Semver - The semver range used to match against git repository tags. This takes precedence over tag.
	Semver *string `json:"semver,omitempty"`
	// Commit - The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver.
	Commit *string `json:"commit,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySet the resource model definition containing the full set of allowed
// properties for a resource. Except properties bag, there cannot be a top level property outside of this
// set.
type ResourceModelWithAllowedPropertySet struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ManagedBy - The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Kind - Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
	Kind *string `json:"kind,omitempty"`
	// Etag - READ-ONLY; The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags     map[string]*string                           `json:"tags"`
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`
	Sku      *ResourceModelWithAllowedPropertySetSku      `json:"sku,omitempty"`
	Plan     *ResourceModelWithAllowedPropertySetPlan     `json:"plan,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceModelWithAllowedPropertySet.
func (rmwaps ResourceModelWithAllowedPropertySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmwaps.Location != nil {
		objectMap["location"] = rmwaps.Location
	}
	if rmwaps.ManagedBy != nil {
		objectMap["managedBy"] = rmwaps.ManagedBy
	}
	if rmwaps.Kind != nil {
		objectMap["kind"] = rmwaps.Kind
	}
	if rmwaps.Tags != nil {
		objectMap["tags"] = rmwaps.Tags
	}
	if rmwaps.Identity != nil {
		objectMap["identity"] = rmwaps.Identity
	}
	if rmwaps.Sku != nil {
		objectMap["sku"] = rmwaps.Sku
	}
	if rmwaps.Plan != nil {
		objectMap["plan"] = rmwaps.Plan
	}
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySetIdentity ...
type ResourceModelWithAllowedPropertySetIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceModelWithAllowedPropertySetIdentity.
func (rmwaps ResourceModelWithAllowedPropertySetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmwaps.Type != "" {
		objectMap["type"] = rmwaps.Type
	}
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySetPlan ...
type ResourceModelWithAllowedPropertySetPlan struct {
	// Name - A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`
	// Product - The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`
	// PromotionCode - A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

// ResourceModelWithAllowedPropertySetSku ...
type ResourceModelWithAllowedPropertySetSku struct {
	// Name - The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`
	// Tier - Possible values include: 'SkuTierFree', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ResourceProviderOperation supported operation of this resource provider.
type ResourceProviderOperation struct {
	// Name - Operation name, in format of {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`
	// IsDataAction - READ-ONLY; The flag that indicates whether the operation applies to data plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Origin - READ-ONLY; Origin of the operation
	Origin *string `json:"origin,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceProviderOperation.
func (rpo ResourceProviderOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpo.Name != nil {
		objectMap["name"] = rpo.Name
	}
	if rpo.Display != nil {
		objectMap["display"] = rpo.Display
	}
	return json.Marshal(objectMap)
}

// ResourceProviderOperationDisplay display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Provider - Resource provider: Microsoft KubernetesConfiguration.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of this operation.
	Description *string `json:"description,omitempty"`
}

// ResourceProviderOperationList result of the request to list operations.
type ResourceProviderOperationList struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by this resource provider.
	Value *[]ResourceProviderOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceProviderOperationList.
func (rpol ResourceProviderOperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpol.Value != nil {
		objectMap["value"] = rpol.Value
	}
	return json.Marshal(objectMap)
}

// ResourceProviderOperationListIterator provides access to a complete listing of ResourceProviderOperation
// values.
type ResourceProviderOperationListIterator struct {
	i    int
	page ResourceProviderOperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceProviderOperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceProviderOperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceProviderOperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceProviderOperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceProviderOperationListIterator) Response() ResourceProviderOperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceProviderOperationListIterator) Value() ResourceProviderOperation {
	if !iter.page.NotDone() {
		return ResourceProviderOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceProviderOperationListIterator type.
func NewResourceProviderOperationListIterator(page ResourceProviderOperationListPage) ResourceProviderOperationListIterator {
	return ResourceProviderOperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rpol ResourceProviderOperationList) IsEmpty() bool {
	return rpol.Value == nil || len(*rpol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rpol ResourceProviderOperationList) hasNextLink() bool {
	return rpol.NextLink != nil && len(*rpol.NextLink) != 0
}

// resourceProviderOperationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rpol ResourceProviderOperationList) resourceProviderOperationListPreparer(ctx context.Context) (*http.Request, error) {
	if !rpol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rpol.NextLink)))
}

// ResourceProviderOperationListPage contains a page of ResourceProviderOperation values.
type ResourceProviderOperationListPage struct {
	fn   func(context.Context, ResourceProviderOperationList) (ResourceProviderOperationList, error)
	rpol ResourceProviderOperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceProviderOperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceProviderOperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rpol)
		if err != nil {
			return err
		}
		page.rpol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceProviderOperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceProviderOperationListPage) NotDone() bool {
	return !page.rpol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceProviderOperationListPage) Response() ResourceProviderOperationList {
	return page.rpol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceProviderOperationListPage) Values() []ResourceProviderOperation {
	if page.rpol.IsEmpty() {
		return nil
	}
	return *page.rpol.Value
}

// Creates a new instance of the ResourceProviderOperationListPage type.
func NewResourceProviderOperationListPage(cur ResourceProviderOperationList, getNextPage func(context.Context, ResourceProviderOperationList) (ResourceProviderOperationList, error)) ResourceProviderOperationListPage {
	return ResourceProviderOperationListPage{
		fn:   getNextPage,
		rpol: cur,
	}
}

// Scope scope of the extension. It can be either Cluster or Namespace; but not both.
type Scope struct {
	// Cluster - Specifies that the scope of the extension is Cluster
	Cluster *ScopeCluster `json:"cluster,omitempty"`
	// Namespace - Specifies that the scope of the extension is Namespace
	Namespace *ScopeNamespace `json:"namespace,omitempty"`
}

// ScopeCluster specifies that the scope of the extension is Cluster
type ScopeCluster struct {
	// ReleaseNamespace - Namespace where the extension Release must be placed, for a Cluster scoped extension.  If this namespace does not exist, it will be created
	ReleaseNamespace *string `json:"releaseNamespace,omitempty"`
}

// ScopeNamespace specifies that the scope of the extension is Namespace
type ScopeNamespace struct {
	// TargetNamespace - Namespace where the extension will be created for an Namespace scoped extension.  If this namespace does not exist, it will be created
	TargetNamespace *string `json:"targetNamespace,omitempty"`
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`
	// Tier - Possible values include: 'SkuTierFree', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SourceControlConfiguration the SourceControl Configuration object returned in Get & Put response.
type SourceControlConfiguration struct {
	autorest.Response `json:"-"`
	// SourceControlConfigurationProperties - Properties to create a Source Control Configuration resource
	*SourceControlConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlConfiguration.
func (scc SourceControlConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scc.SourceControlConfigurationProperties != nil {
		objectMap["properties"] = scc.SourceControlConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControlConfiguration struct.
func (scc *SourceControlConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sourceControlConfigurationProperties SourceControlConfigurationProperties
				err = json.Unmarshal(*v, &sourceControlConfigurationProperties)
				if err != nil {
					return err
				}
				scc.SourceControlConfigurationProperties = &sourceControlConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				scc.SystemData = &systemData
			}
		}
	}

	return nil
}

// SourceControlConfigurationList result of the request to list Source Control Configurations.  It contains
// a list of SourceControlConfiguration objects and a URL link to get the next set of results.
type SourceControlConfigurationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Source Control Configurations within a Kubernetes cluster.
	Value *[]SourceControlConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of configuration objects, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlConfigurationList.
func (sccl SourceControlConfigurationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SourceControlConfigurationListIterator provides access to a complete listing of
// SourceControlConfiguration values.
type SourceControlConfigurationListIterator struct {
	i    int
	page SourceControlConfigurationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SourceControlConfigurationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlConfigurationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SourceControlConfigurationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SourceControlConfigurationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SourceControlConfigurationListIterator) Response() SourceControlConfigurationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SourceControlConfigurationListIterator) Value() SourceControlConfiguration {
	if !iter.page.NotDone() {
		return SourceControlConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SourceControlConfigurationListIterator type.
func NewSourceControlConfigurationListIterator(page SourceControlConfigurationListPage) SourceControlConfigurationListIterator {
	return SourceControlConfigurationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sccl SourceControlConfigurationList) IsEmpty() bool {
	return sccl.Value == nil || len(*sccl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sccl SourceControlConfigurationList) hasNextLink() bool {
	return sccl.NextLink != nil && len(*sccl.NextLink) != 0
}

// sourceControlConfigurationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sccl SourceControlConfigurationList) sourceControlConfigurationListPreparer(ctx context.Context) (*http.Request, error) {
	if !sccl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sccl.NextLink)))
}

// SourceControlConfigurationListPage contains a page of SourceControlConfiguration values.
type SourceControlConfigurationListPage struct {
	fn   func(context.Context, SourceControlConfigurationList) (SourceControlConfigurationList, error)
	sccl SourceControlConfigurationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SourceControlConfigurationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlConfigurationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sccl)
		if err != nil {
			return err
		}
		page.sccl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SourceControlConfigurationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SourceControlConfigurationListPage) NotDone() bool {
	return !page.sccl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SourceControlConfigurationListPage) Response() SourceControlConfigurationList {
	return page.sccl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SourceControlConfigurationListPage) Values() []SourceControlConfiguration {
	if page.sccl.IsEmpty() {
		return nil
	}
	return *page.sccl.Value
}

// Creates a new instance of the SourceControlConfigurationListPage type.
func NewSourceControlConfigurationListPage(cur SourceControlConfigurationList, getNextPage func(context.Context, SourceControlConfigurationList) (SourceControlConfigurationList, error)) SourceControlConfigurationListPage {
	return SourceControlConfigurationListPage{
		fn:   getNextPage,
		sccl: cur,
	}
}

// SourceControlConfigurationProperties properties to create a Source Control Configuration resource
type SourceControlConfigurationProperties struct {
	// RepositoryURL - Url of the SourceControl Repository.
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// OperatorNamespace - The namespace to which this operator is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
	OperatorNamespace *string `json:"operatorNamespace,omitempty"`
	// OperatorInstanceName - Instance name of the operator - identifying the specific configuration.
	OperatorInstanceName *string `json:"operatorInstanceName,omitempty"`
	// OperatorType - Type of the operator. Possible values include: 'OperatorTypeFlux'
	OperatorType OperatorType `json:"operatorType,omitempty"`
	// OperatorParams - Any Parameters for the Operator instance in string format.
	OperatorParams *string `json:"operatorParams,omitempty"`
	// ConfigurationProtectedSettings - Name-value pairs of protected configuration settings for the configuration
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings"`
	// OperatorScope - Scope at which the operator will be installed. Possible values include: 'OperatorScopeTypeCluster', 'OperatorScopeTypeNamespace'
	OperatorScope OperatorScopeType `json:"operatorScope,omitempty"`
	// RepositoryPublicKey - READ-ONLY; Public Key associated with this SourceControl configuration (either generated within the cluster or provided by the user).
	RepositoryPublicKey *string `json:"repositoryPublicKey,omitempty"`
	// SSHKnownHostsContents - Base64-encoded known_hosts contents containing public SSH keys required to access private Git instances
	SSHKnownHostsContents *string `json:"sshKnownHostsContents,omitempty"`
	// EnableHelmOperator - Option to enable Helm Operator for this git configuration.
	EnableHelmOperator *bool `json:"enableHelmOperator,omitempty"`
	// HelmOperatorProperties - Properties for Helm operator.
	HelmOperatorProperties *HelmOperatorProperties `json:"helmOperatorProperties,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource provider. Possible values include: 'ProvisioningStateTypeAccepted', 'ProvisioningStateTypeDeleting', 'ProvisioningStateTypeRunning', 'ProvisioningStateTypeSucceeded', 'ProvisioningStateTypeFailed'
	ProvisioningState ProvisioningStateType `json:"provisioningState,omitempty"`
	// ComplianceStatus - READ-ONLY; Compliance Status of the Configuration
	ComplianceStatus *ComplianceStatus `json:"complianceStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlConfigurationProperties.
func (scc SourceControlConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scc.RepositoryURL != nil {
		objectMap["repositoryUrl"] = scc.RepositoryURL
	}
	if scc.OperatorNamespace != nil {
		objectMap["operatorNamespace"] = scc.OperatorNamespace
	}
	if scc.OperatorInstanceName != nil {
		objectMap["operatorInstanceName"] = scc.OperatorInstanceName
	}
	if scc.OperatorType != "" {
		objectMap["operatorType"] = scc.OperatorType
	}
	if scc.OperatorParams != nil {
		objectMap["operatorParams"] = scc.OperatorParams
	}
	if scc.ConfigurationProtectedSettings != nil {
		objectMap["configurationProtectedSettings"] = scc.ConfigurationProtectedSettings
	}
	if scc.OperatorScope != "" {
		objectMap["operatorScope"] = scc.OperatorScope
	}
	if scc.SSHKnownHostsContents != nil {
		objectMap["sshKnownHostsContents"] = scc.SSHKnownHostsContents
	}
	if scc.EnableHelmOperator != nil {
		objectMap["enableHelmOperator"] = scc.EnableHelmOperator
	}
	if scc.HelmOperatorProperties != nil {
		objectMap["helmOperatorProperties"] = scc.HelmOperatorProperties
	}
	return json.Marshal(objectMap)
}

// SourceControlConfigurationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SourceControlConfigurationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SourceControlConfigurationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SourceControlConfigurationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SourceControlConfigurationsDeleteFuture.Result.
func (future *SourceControlConfigurationsDeleteFuture) result(client SourceControlConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.SourceControlConfigurationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.SourceControlConfigurationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TagsResource a container holding only the Tags for a resource, allowing the user to update the tags on a
// PrivateLinkScope instance.
type TagsResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsResource.
func (tr TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}
