// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by go/autofill-i18n-model-git. Do not manually edit.

#ifndef COMPONENTS_AUTOFILL_CORE_BROWSER_DATA_MODEL_AUTOFILL_I18N_STOPWORDS_H_
#define COMPONENTS_AUTOFILL_CORE_BROWSER_DATA_MODEL_AUTOFILL_I18N_STOPWORDS_H_

#include <string_view>

#include "base/containers/fixed_flat_map.h"
#include "components/autofill/core/browser/field_types.h"

namespace autofill::i18n_model_definition {

// A pair of country code and server field type used as keys in the
// `kAutofillModelStopwords`.
using CountryAndFieldType = std::pair<std::string_view, FieldType>;

// A lookup map for stopwords for countries and field types.
constexpr auto kAutofillModelStopwords =
    base::MakeFixedFlatMap<CountryAndFieldType, std::u16string_view>({
      {{"BR", ADDRESS_HOME_OVERFLOW_AND_LANDMARK}, u"Ponto de referência:"},
      {{"BR", ADDRESS_HOME_SUBPREMISE}, u"Andar"},
      {{"MX", ADDRESS_HOME_SUBPREMISE}, u"Piso"},
      {{"MX", ADDRESS_HOME_BETWEEN_STREETS_OR_LANDMARK}, u"Entre Calles"},
      {{"MX", ADDRESS_HOME_BETWEEN_STREETS}, u" y "},
      {{"XX", ADDRESS_HOME_SUBPREMISE}, u"Apt\\.|Floor"}
      });

}  // namespace autofill::i18n_model_definition

#endif  // COMPONENTS_AUTOFILL_CORE_BROWSER_DATA_MODEL_AUTOFILL_I18N_STOPWORDS_H_
