---
myst:
  html_meta:
    keywords: LaTeX,graphique,statistiques,TikZ,barplot,histogramme,tracer une fonction,mathématiques,data science
---
# Comment inclure un graphique ?

Imaginons que vous ayez un tableau de données, et que vous souhaitiez en faire une représentation graphique dans votre document LaTeX. Pour cela, vous n'avez besoin d'aucun logiciel externe. En dessinant votre graphique directement en LaTeX, vous aurez une intégration complète du texte et de la figure : police de caracatères identique, taille de la figure qui s'adapte à la taille du texte, couleurs identiques (si besoin).

:::{note}
Si vous avez déjà un graphique, obtenu à partir d'un autre logiciel (R, MatLab, LibreOffice, Excel...) vous pouvez simplement l'inclure avec :

```{noedit}
\includegraphics[width=50ex]{fichier}
```

Dans ce cas, il est préférable que le graphique soit au format PDF, mais il est également possible d'inclure du PNG ou du JPEG.

Voir la question « [](/3_composition/illustrations/inclure_une_image/inclure_une_image) ».
:::

## Avec l'extension <ctanpkg:PGFPlots>

L'extension <ctanpkg:PGFPlots> utilise [TikZ](ctanpkg:pgf) pour construire le dessin, tout en fournissant une syntaxe intuitive pour décrire le résultat que vous voulez.

Elle propose un environnement `axis`, dont les paramètres modifient le style de graphique :

Par défaut, les nombres sont affichés avec le point comme séparateur de décimal. On propose ici un exmple permettant de régler ce « problème », ainsi que les réglages principaux d’un graphique.

```
\documentclass[french]{article}
\usepackage[utf8]{inputenc}
\usepackage[T1]{fontenc}
\usepackage{tikz}
\usepackage{xcolor}
\usepackage{pgfplots}
\usepackage{siunitx}
\sisetup{locale = FR}
\usepackage{babel}
% -------------------------------------------------------------------------------
\begin{document}
\begin{tikzpicture}
  \begin{axis}[
    y tick label style={%
      /pgf/number format/.cd,
      set thousands separator={\,},
      set decimal separator={,},
      fixed,
      /tikz/.cd
    },
    x tick label style={
      /pgf/number format/.cd,
      set decimal separator={,},
      set thousands separator={\,},
      fixed,
      /tikz/.cd 
    },
    width  = 1 \linewidth,
    height = 7.5cm,
    ymin=0,
    xmin=0,
    xlabel=$c/\unit{\mol\per\l}$,
    ylabel=$A$,
    grid = both,
    minor tick num=4,
    tickpos=left,
    scaled ticks=true, % pour ajouter puisssance de 10 globale
    scaled x ticks=base 10:5,
    tick scale binop=\times, % avec le signe "x" au lieu du point
    domain=0:6,
    minor grid style = {color=gray!25},
    major grid style = {color = gray },
    legend pos = north west,
    legend entries={Points expérimentaux, $A=\num{2.1e3} \times c$},
    title= Courbe d’étalonnage,
    ]
    \addplot[only marks, red, mark=*] coordinates {
      (3e-5,    0.068)
      (4e-5,    0.073)
      (5e-5,    0.111)
      (6e-5,    0.115)
      (8e-5,    0.151)
      (10e-5,   0.249)
    };
    \addplot[blue, domain=0:1.2e-4]{2.1e3*\x};
    % \legend()
  \end{axis}
\end{tikzpicture}
\end{document}
```

Si certains réglages sont communs à plusieurs graphiques du document (typiquement le réglage des nombres en « français »), on pourra les faire dans le préambule à l’aide de la commande `pgfplotsset{}`

```{noedit}
\pgfplotsset{compat=newest,
  y tick label style={%
    /pgf/number format/.cd,
    set thousands separator={\,},
    set decimal separator={,},
    fixed,
    /tikz/.cd
  },
  x tick label style={%
    /pgf/number format/.cd,
    set decimal separator={,},
    set thousands separator={\,},%scaled ticks=base 10:3,
    fixed,
    /tikz/.cd % on se replace dans le bon dossier
  },
  minor grid style = {color=lightgray!30},
  major grid style = {color=lightgray},
  scaled ticks=true, % pour ajouter puisssance de 10 globale
  tick scale binop=\times, % avec le signe "x"
  tickpos=left,
}
```

## Avec l'extension <ctanpkg:TikZ> (mais sans <ctanpkg:PGFPlots>)

Si votre graphique est tellement particulier qu'il s'écarte de ce que sait faire <ctanpkg:PGFPlots>, vous pouvez très bien utiliser directement <ctanpkg:TikZ>.

Ici, un exemple plutôt simple pour construire un repère avec des axes gradués :

```
\documentclass{article}
  \usepackage{tikz}
  \usepackage{verbatim}
  \pagestyle{empty}

\begin{comment}
:Title : Scatterplot
:Tags : Plots, Axes, Foreach

A scatterplot of the relationship between education and income. The plotted
data is from the `car R package`_ by John Fox. Note that the data is released
under the GPL 2 licence.

:Author : Ista Zahn

.. _car R package : http://cran.r-project.org/src/contrib/Descriptions/car.html
\end{comment}

\begin{document}
\begin{tikzpicture}[scale=.5, only marks, y=.5cm]
    %%\draw plot[mark=*,xshift=-6cm] file {data/ScatterPlotExampleData.data};
    \draw[->,xshift=-6cm] (6,0) -- coordinate (x axis mid) (17,0);
    \draw[->,xshift=-6cm] (6,0) -- coordinate (y axis mid)(6,27);
    \foreach \x in {6,8,10,12,14,16}
        \draw [xshift=-6cm](\x cm,1pt) -- (\x cm,-3pt)
            node[anchor=north] {$\x$};
    \foreach \y/\ytext in {0/0,2.5/5000,5/10000,7.5/15000,10/20000,12.5/25000}
        \draw (1pt,\y cm) -- (-3pt,\y cm) node[anchor=east] {$\ytext$};
    \node[below=5mm] at (x axis mid) {Années d'études};
    \node[left=15mm,rotate=90] at (y axis mid) {Revenus};
\end{tikzpicture}
\end{document}
```

## Avec l'extension <ctanpkg:PSTricks>

:::{todo} Proposer un exemple avec <ctanpkg:PSTricks>.
:::

:::{sources}
- [Les graphiques sous TikZ](https://blog.dorian-depriester.fr/latex/tikz/les-graphiques-sous-tikz),
- [Comment faire de beaux graphiques avec Tikz et PGFPLOTS](http://bertrandmasson.free.fr/index.php?article28/comment-faire-de-beaux-graphiques-avec-tikz-et-pgfplots),
- [Plots examples](https://texample.net/tikz/examples/tag/plots/).
:::
