#ifndef _UOS_RECOVERY_BTRFS_USER_DATA_H_
#define _UOS_RECOVERY_BTRFS_USER_DATA_H_

#include "UserDataRecovery.h"

class BtrfsUserData : public UserDataRecovery
{
    Q_OBJECT
public:
    explicit BtrfsUserData();
    virtual ~BtrfsUserData();

    bool supported(FSTabInfoList &fsTabInfoList) override;
    //备份用户数据
    ErrorCode userDataBackup(UserDataBackupRequest &request) override;
    ErrorCode checkUserDataBackupSpace(UserDataBackupRequest &request) override;

    //还原用户数据
    ErrorCode userDataRestore(UserDataRestoreRequest &request) override;
    BackupInfoList listUserDataBackup(const QString &username) override;
    ErrorCode removeUserDataBackup(RemoveUserDataBackupRequest &request) override;

private:
    void writeBackupInfo();
    ErrorCode fillBackupInfo();
    ErrorCode parseUserDataBackupReq(const UserDataBackupRequest &request);

private:
    BackupInfo m_backupInfo;
    UserDataBackupRequest m_request;
};

#endif
