//
// Copyright 2022 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gl_1_params.cpp:
//   Pointer parameter capture functions for the OpenGL 1.x entry points.

#include "libANGLE/capture/capture_gl_1_autogen.h"

namespace gl
{
// GL 1.0
void CaptureBitmap_bitmap(const State &glState,
                          bool isCallValid,
                          GLsizei width,
                          GLsizei height,
                          GLfloat xorig,
                          GLfloat yorig,
                          GLfloat xmove,
                          GLfloat ymove,
                          const GLubyte *bitmap,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureCallLists_lists(const State &glState,
                            bool isCallValid,
                            GLsizei n,
                            GLenum type,
                            const void *lists,
                            angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureClipPlane_equation(const State &glState,
                               bool isCallValid,
                               GLenum plane,
                               const GLdouble *equation,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor3bv_v(const State &glState,
                       bool isCallValid,
                       const GLbyte *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor3dv_v(const State &glState,
                       bool isCallValid,
                       const GLdouble *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor3fv_v(const State &glState,
                       bool isCallValid,
                       const GLfloat *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor3iv_v(const State &glState,
                       bool isCallValid,
                       const GLint *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor3sv_v(const State &glState,
                       bool isCallValid,
                       const GLshort *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor3ubv_v(const State &glState,
                        bool isCallValid,
                        const GLubyte *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor3uiv_v(const State &glState,
                        bool isCallValid,
                        const GLuint *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor3usv_v(const State &glState,
                        bool isCallValid,
                        const GLushort *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor4bv_v(const State &glState,
                       bool isCallValid,
                       const GLbyte *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor4dv_v(const State &glState,
                       bool isCallValid,
                       const GLdouble *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor4fv_v(const State &glState,
                       bool isCallValid,
                       const GLfloat *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor4iv_v(const State &glState,
                       bool isCallValid,
                       const GLint *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor4sv_v(const State &glState,
                       bool isCallValid,
                       const GLshort *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor4ubv_v(const State &glState,
                        bool isCallValid,
                        const GLubyte *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor4uiv_v(const State &glState,
                        bool isCallValid,
                        const GLuint *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureColor4usv_v(const State &glState,
                        bool isCallValid,
                        const GLushort *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureDrawPixels_pixels(const State &glState,
                              bool isCallValid,
                              GLsizei width,
                              GLsizei height,
                              GLenum format,
                              GLenum type,
                              const void *pixels,
                              angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureEdgeFlagv_flag(const State &glState,
                           bool isCallValid,
                           const GLboolean *flag,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureEvalCoord1dv_u(const State &glState,
                           bool isCallValid,
                           const GLdouble *u,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureEvalCoord1fv_u(const State &glState,
                           bool isCallValid,
                           const GLfloat *u,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureEvalCoord2dv_u(const State &glState,
                           bool isCallValid,
                           const GLdouble *u,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureEvalCoord2fv_u(const State &glState,
                           bool isCallValid,
                           const GLfloat *u,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureFeedbackBuffer_buffer(const State &glState,
                                  bool isCallValid,
                                  GLsizei size,
                                  GLenum type,
                                  GLfloat *buffer,
                                  angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureFogiv_params(const State &glState,
                         bool isCallValid,
                         GLenum pname,
                         const GLint *params,
                         angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetClipPlane_equation(const State &glState,
                                  bool isCallValid,
                                  GLenum plane,
                                  GLdouble *equation,
                                  angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetDoublev_data(const State &glState,
                            bool isCallValid,
                            GLenum pname,
                            GLdouble *data,
                            angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetLightiv_params(const State &glState,
                              bool isCallValid,
                              GLenum light,
                              GLenum pname,
                              GLint *params,
                              angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetMapdv_v(const State &glState,
                       bool isCallValid,
                       GLenum target,
                       GLenum query,
                       GLdouble *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetMapfv_v(const State &glState,
                       bool isCallValid,
                       GLenum target,
                       GLenum query,
                       GLfloat *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetMapiv_v(const State &glState,
                       bool isCallValid,
                       GLenum target,
                       GLenum query,
                       GLint *v,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetMaterialiv_params(const State &glState,
                                 bool isCallValid,
                                 GLenum face,
                                 GLenum pname,
                                 GLint *params,
                                 angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetPixelMapfv_values(const State &glState,
                                 bool isCallValid,
                                 GLenum map,
                                 GLfloat *values,
                                 angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetPixelMapuiv_values(const State &glState,
                                  bool isCallValid,
                                  GLenum map,
                                  GLuint *values,
                                  angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetPixelMapusv_values(const State &glState,
                                  bool isCallValid,
                                  GLenum map,
                                  GLushort *values,
                                  angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetPolygonStipple_mask(const State &glState,
                                   bool isCallValid,
                                   GLubyte *mask,
                                   angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetTexGendv_params(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               GLdouble *params,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetTexGenfv_params(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               GLfloat *params,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetTexGeniv_params(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               GLint *params,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetTexImage_pixels(const State &glState,
                               bool isCallValid,
                               TextureTarget targetPacked,
                               GLint level,
                               GLenum format,
                               GLenum type,
                               void *pixels,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureIndexdv_c(const State &glState,
                      bool isCallValid,
                      const GLdouble *c,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureIndexfv_c(const State &glState,
                      bool isCallValid,
                      const GLfloat *c,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureIndexiv_c(const State &glState,
                      bool isCallValid,
                      const GLint *c,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureIndexsv_c(const State &glState,
                      bool isCallValid,
                      const GLshort *c,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureLightModeliv_params(const State &glState,
                                bool isCallValid,
                                GLenum pname,
                                const GLint *params,
                                angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureLightiv_params(const State &glState,
                           bool isCallValid,
                           GLenum light,
                           GLenum pname,
                           const GLint *params,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureLoadMatrixd_m(const State &glState,
                          bool isCallValid,
                          const GLdouble *m,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMap1d_points(const State &glState,
                         bool isCallValid,
                         GLenum target,
                         GLdouble u1,
                         GLdouble u2,
                         GLint stride,
                         GLint order,
                         const GLdouble *points,
                         angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMap1f_points(const State &glState,
                         bool isCallValid,
                         GLenum target,
                         GLfloat u1,
                         GLfloat u2,
                         GLint stride,
                         GLint order,
                         const GLfloat *points,
                         angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMap2d_points(const State &glState,
                         bool isCallValid,
                         GLenum target,
                         GLdouble u1,
                         GLdouble u2,
                         GLint ustride,
                         GLint uorder,
                         GLdouble v1,
                         GLdouble v2,
                         GLint vstride,
                         GLint vorder,
                         const GLdouble *points,
                         angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMap2f_points(const State &glState,
                         bool isCallValid,
                         GLenum target,
                         GLfloat u1,
                         GLfloat u2,
                         GLint ustride,
                         GLint uorder,
                         GLfloat v1,
                         GLfloat v2,
                         GLint vstride,
                         GLint vorder,
                         const GLfloat *points,
                         angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMaterialiv_params(const State &glState,
                              bool isCallValid,
                              GLenum face,
                              GLenum pname,
                              const GLint *params,
                              angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultMatrixd_m(const State &glState,
                          bool isCallValid,
                          const GLdouble *m,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureNormal3bv_v(const State &glState,
                        bool isCallValid,
                        const GLbyte *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureNormal3dv_v(const State &glState,
                        bool isCallValid,
                        const GLdouble *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureNormal3fv_v(const State &glState,
                        bool isCallValid,
                        const GLfloat *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureNormal3iv_v(const State &glState,
                        bool isCallValid,
                        const GLint *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureNormal3sv_v(const State &glState,
                        bool isCallValid,
                        const GLshort *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CapturePixelMapfv_values(const State &glState,
                              bool isCallValid,
                              GLenum map,
                              GLsizei mapsize,
                              const GLfloat *values,
                              angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CapturePixelMapuiv_values(const State &glState,
                               bool isCallValid,
                               GLenum map,
                               GLsizei mapsize,
                               const GLuint *values,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CapturePixelMapusv_values(const State &glState,
                               bool isCallValid,
                               GLenum map,
                               GLsizei mapsize,
                               const GLushort *values,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CapturePolygonStipple_mask(const State &glState,
                                bool isCallValid,
                                const GLubyte *mask,
                                angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos2dv_v(const State &glState,
                           bool isCallValid,
                           const GLdouble *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos2fv_v(const State &glState,
                           bool isCallValid,
                           const GLfloat *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos2iv_v(const State &glState,
                           bool isCallValid,
                           const GLint *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos2sv_v(const State &glState,
                           bool isCallValid,
                           const GLshort *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos3dv_v(const State &glState,
                           bool isCallValid,
                           const GLdouble *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos3fv_v(const State &glState,
                           bool isCallValid,
                           const GLfloat *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos3iv_v(const State &glState,
                           bool isCallValid,
                           const GLint *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos3sv_v(const State &glState,
                           bool isCallValid,
                           const GLshort *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos4dv_v(const State &glState,
                           bool isCallValid,
                           const GLdouble *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos4fv_v(const State &glState,
                           bool isCallValid,
                           const GLfloat *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos4iv_v(const State &glState,
                           bool isCallValid,
                           const GLint *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRasterPos4sv_v(const State &glState,
                           bool isCallValid,
                           const GLshort *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRectdv_v1(const State &glState,
                      bool isCallValid,
                      const GLdouble *v1,
                      const GLdouble *v2,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRectdv_v2(const State &glState,
                      bool isCallValid,
                      const GLdouble *v1,
                      const GLdouble *v2,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRectfv_v1(const State &glState,
                      bool isCallValid,
                      const GLfloat *v1,
                      const GLfloat *v2,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRectfv_v2(const State &glState,
                      bool isCallValid,
                      const GLfloat *v1,
                      const GLfloat *v2,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRectiv_v1(const State &glState,
                      bool isCallValid,
                      const GLint *v1,
                      const GLint *v2,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRectiv_v2(const State &glState,
                      bool isCallValid,
                      const GLint *v1,
                      const GLint *v2,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRectsv_v1(const State &glState,
                      bool isCallValid,
                      const GLshort *v1,
                      const GLshort *v2,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureRectsv_v2(const State &glState,
                      bool isCallValid,
                      const GLshort *v1,
                      const GLshort *v2,
                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureSelectBuffer_buffer(const State &glState,
                                bool isCallValid,
                                GLsizei size,
                                GLuint *buffer,
                                angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord1dv_v(const State &glState,
                          bool isCallValid,
                          const GLdouble *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord1fv_v(const State &glState,
                          bool isCallValid,
                          const GLfloat *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord1iv_v(const State &glState,
                          bool isCallValid,
                          const GLint *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord1sv_v(const State &glState,
                          bool isCallValid,
                          const GLshort *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord2dv_v(const State &glState,
                          bool isCallValid,
                          const GLdouble *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord2fv_v(const State &glState,
                          bool isCallValid,
                          const GLfloat *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord2iv_v(const State &glState,
                          bool isCallValid,
                          const GLint *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord2sv_v(const State &glState,
                          bool isCallValid,
                          const GLshort *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord3dv_v(const State &glState,
                          bool isCallValid,
                          const GLdouble *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord3fv_v(const State &glState,
                          bool isCallValid,
                          const GLfloat *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord3iv_v(const State &glState,
                          bool isCallValid,
                          const GLint *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord3sv_v(const State &glState,
                          bool isCallValid,
                          const GLshort *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord4dv_v(const State &glState,
                          bool isCallValid,
                          const GLdouble *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord4fv_v(const State &glState,
                          bool isCallValid,
                          const GLfloat *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord4iv_v(const State &glState,
                          bool isCallValid,
                          const GLint *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexCoord4sv_v(const State &glState,
                          bool isCallValid,
                          const GLshort *v,
                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexGendv_params(const State &glState,
                            bool isCallValid,
                            GLenum coord,
                            GLenum pname,
                            const GLdouble *params,
                            angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexGenfv_params(const State &glState,
                            bool isCallValid,
                            GLenum coord,
                            GLenum pname,
                            const GLfloat *params,
                            angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexGeniv_params(const State &glState,
                            bool isCallValid,
                            GLenum coord,
                            GLenum pname,
                            const GLint *params,
                            angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexImage1D_pixels(const State &glState,
                              bool isCallValid,
                              GLenum target,
                              GLint level,
                              GLint internalformat,
                              GLsizei width,
                              GLint border,
                              GLenum format,
                              GLenum type,
                              const void *pixels,
                              angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex2dv_v(const State &glState,
                        bool isCallValid,
                        const GLdouble *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex2fv_v(const State &glState,
                        bool isCallValid,
                        const GLfloat *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex2iv_v(const State &glState,
                        bool isCallValid,
                        const GLint *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex2sv_v(const State &glState,
                        bool isCallValid,
                        const GLshort *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex3dv_v(const State &glState,
                        bool isCallValid,
                        const GLdouble *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex3fv_v(const State &glState,
                        bool isCallValid,
                        const GLfloat *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex3iv_v(const State &glState,
                        bool isCallValid,
                        const GLint *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex3sv_v(const State &glState,
                        bool isCallValid,
                        const GLshort *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex4dv_v(const State &glState,
                        bool isCallValid,
                        const GLdouble *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex4fv_v(const State &glState,
                        bool isCallValid,
                        const GLfloat *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex4iv_v(const State &glState,
                        bool isCallValid,
                        const GLint *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureVertex4sv_v(const State &glState,
                        bool isCallValid,
                        const GLshort *v,
                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}

// GL 1.1
void CaptureAreTexturesResident_textures(const State &glState,
                                         bool isCallValid,
                                         GLsizei n,
                                         const GLuint *textures,
                                         GLboolean *residences,
                                         angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureAreTexturesResident_residences(const State &glState,
                                           bool isCallValid,
                                           GLsizei n,
                                           const GLuint *textures,
                                           GLboolean *residences,
                                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureEdgeFlagPointer_pointer(const State &glState,
                                    bool isCallValid,
                                    GLsizei stride,
                                    const void *pointer,
                                    angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureIndexPointer_pointer(const State &glState,
                                 bool isCallValid,
                                 GLenum type,
                                 GLsizei stride,
                                 const void *pointer,
                                 angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureIndexubv_c(const State &glState,
                       bool isCallValid,
                       const GLubyte *c,
                       angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureInterleavedArrays_pointer(const State &glState,
                                      bool isCallValid,
                                      GLenum format,
                                      GLsizei stride,
                                      const void *pointer,
                                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CapturePrioritizeTextures_textures(const State &glState,
                                        bool isCallValid,
                                        GLsizei n,
                                        const GLuint *textures,
                                        const GLfloat *priorities,
                                        angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CapturePrioritizeTextures_priorities(const State &glState,
                                          bool isCallValid,
                                          GLsizei n,
                                          const GLuint *textures,
                                          const GLfloat *priorities,
                                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureTexSubImage1D_pixels(const State &glState,
                                 bool isCallValid,
                                 GLenum target,
                                 GLint level,
                                 GLint xoffset,
                                 GLsizei width,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels,
                                 angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}

// GL 1.2
void CaptureCompressedTexImage1D_data(const State &glState,
                                      bool isCallValid,
                                      GLenum target,
                                      GLint level,
                                      GLenum internalformat,
                                      GLsizei width,
                                      GLint border,
                                      GLsizei imageSize,
                                      const void *data,
                                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureCompressedTexSubImage1D_data(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLint level,
                                         GLint xoffset,
                                         GLsizei width,
                                         GLenum format,
                                         GLsizei imageSize,
                                         const void *data,
                                         angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetCompressedTexImage_img(const State &glState,
                                      bool isCallValid,
                                      TextureTarget targetPacked,
                                      GLint level,
                                      void *img,
                                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureLoadTransposeMatrixd_m(const State &glState,
                                   bool isCallValid,
                                   const GLdouble *m,
                                   angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureLoadTransposeMatrixf_m(const State &glState,
                                   bool isCallValid,
                                   const GLfloat *m,
                                   angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultTransposeMatrixd_m(const State &glState,
                                   bool isCallValid,
                                   const GLdouble *m,
                                   angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultTransposeMatrixf_m(const State &glState,
                                   bool isCallValid,
                                   const GLfloat *m,
                                   angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord1dv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLdouble *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord1fv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLfloat *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord1iv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLint *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord1sv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLshort *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord2dv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLdouble *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord2fv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLfloat *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord2iv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLint *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord2sv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLshort *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord3dv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLdouble *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord3fv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLfloat *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord3iv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLint *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord3sv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLshort *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord4dv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLdouble *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord4fv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLfloat *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord4iv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLint *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiTexCoord4sv_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               const GLshort *v,
                               angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}

// GL 1.3
void CaptureFogCoordPointer_pointer(const State &glState,
                                    bool isCallValid,
                                    GLenum type,
                                    GLsizei stride,
                                    const void *pointer,
                                    angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureFogCoorddv_coord(const State &glState,
                             bool isCallValid,
                             const GLdouble *coord,
                             angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureFogCoordfv_coord(const State &glState,
                             bool isCallValid,
                             const GLfloat *coord,
                             angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiDrawArrays_first(const State &glState,
                                  bool isCallValid,
                                  PrimitiveMode modePacked,
                                  const GLint *first,
                                  const GLsizei *count,
                                  GLsizei drawcount,
                                  angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiDrawArrays_count(const State &glState,
                                  bool isCallValid,
                                  PrimitiveMode modePacked,
                                  const GLint *first,
                                  const GLsizei *count,
                                  GLsizei drawcount,
                                  angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiDrawElements_count(const State &glState,
                                    bool isCallValid,
                                    PrimitiveMode modePacked,
                                    const GLsizei *count,
                                    DrawElementsType typePacked,
                                    const void *const *indices,
                                    GLsizei drawcount,
                                    angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureMultiDrawElements_indices(const State &glState,
                                      bool isCallValid,
                                      PrimitiveMode modePacked,
                                      const GLsizei *count,
                                      DrawElementsType typePacked,
                                      const void *const *indices,
                                      GLsizei drawcount,
                                      angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CapturePointParameteriv_params(const State &glState,
                                    bool isCallValid,
                                    GLenum pname,
                                    const GLint *params,
                                    angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureSecondaryColor3bv_v(const State &glState,
                                bool isCallValid,
                                const GLbyte *v,
                                angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureSecondaryColor3dv_v(const State &glState,
                                bool isCallValid,
                                const GLdouble *v,
                                angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureSecondaryColor3fv_v(const State &glState,
                                bool isCallValid,
                                const GLfloat *v,
                                angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureSecondaryColor3iv_v(const State &glState,
                                bool isCallValid,
                                const GLint *v,
                                angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureSecondaryColor3sv_v(const State &glState,
                                bool isCallValid,
                                const GLshort *v,
                                angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureSecondaryColor3ubv_v(const State &glState,
                                 bool isCallValid,
                                 const GLubyte *v,
                                 angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureSecondaryColor3uiv_v(const State &glState,
                                 bool isCallValid,
                                 const GLuint *v,
                                 angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureSecondaryColor3usv_v(const State &glState,
                                 bool isCallValid,
                                 const GLushort *v,
                                 angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureSecondaryColorPointer_pointer(const State &glState,
                                          bool isCallValid,
                                          GLint size,
                                          GLenum type,
                                          GLsizei stride,
                                          const void *pointer,
                                          angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureWindowPos2dv_v(const State &glState,
                           bool isCallValid,
                           const GLdouble *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureWindowPos2fv_v(const State &glState,
                           bool isCallValid,
                           const GLfloat *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureWindowPos2iv_v(const State &glState,
                           bool isCallValid,
                           const GLint *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureWindowPos2sv_v(const State &glState,
                           bool isCallValid,
                           const GLshort *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureWindowPos3dv_v(const State &glState,
                           bool isCallValid,
                           const GLdouble *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureWindowPos3fv_v(const State &glState,
                           bool isCallValid,
                           const GLfloat *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureWindowPos3iv_v(const State &glState,
                           bool isCallValid,
                           const GLint *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureWindowPos3sv_v(const State &glState,
                           bool isCallValid,
                           const GLshort *v,
                           angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}

// GL 1.4
void CaptureGetBufferSubData_data(const State &glState,
                                  bool isCallValid,
                                  GLenum target,
                                  GLintptr offset,
                                  GLsizeiptr size,
                                  void *data,
                                  angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
void CaptureGetQueryObjectiv_params(const State &glState,
                                    bool isCallValid,
                                    QueryID idPacked,
                                    GLenum pname,
                                    GLint *params,
                                    angle::ParamCapture *paramCapture)
{
    UNIMPLEMENTED();
}
}  // namespace gl
