#include "ekg2.h"

#include <string.h>

static const char input_iso[] = {
	0x4c, 0x69, 0x74, 0x77, 0x6f, 0x21, 0x20, 0x4f, 0x6a, 0x63, 0x7a, 0x79,
	0x7a, 0x6e, 0x6f, 0x20, 0x6d, 0x6f, 0x6a, 0x61, 0x21, 0x20, 0x74, 0x79,
	0x20, 0x6a, 0x65, 0x73, 0x74, 0x65, 0xb6, 0x20, 0x6a, 0x61, 0x6b, 0x20,
	0x7a, 0x64, 0x72, 0x6f, 0x77, 0x69, 0x65, 0x3b, 0x0a, 0x49, 0x6c, 0x65,
	0x20, 0x63, 0x69, 0xea, 0x20, 0x74, 0x72, 0x7a, 0x65, 0x62, 0x61, 0x20,
	0x63, 0x65, 0x6e, 0x69, 0xe6, 0x2c, 0x20, 0x74, 0x65, 0x6e, 0x20, 0x74,
	0x79, 0x6c, 0x6b, 0x6f, 0x20, 0x73, 0x69, 0xea, 0x20, 0x64, 0x6f, 0x77,
	0x69, 0x65, 0x2c, 0x0a, 0x4b, 0x74, 0x6f, 0x20, 0x63, 0x69, 0xea, 0x20,
	0x73, 0x74, 0x72, 0x61, 0x63, 0x69, 0xb3, 0x2e, 0x20, 0x44, 0x7a, 0x69,
	0xb6, 0x20, 0x70, 0x69, 0xea, 0x6b, 0x6e, 0x6f, 0xb6, 0xe6, 0x20, 0x74,
	0x77, 0xb1, 0x20, 0x77, 0x20, 0x63, 0x61, 0xb3, 0x65, 0x6a, 0x20, 0x6f,
	0x7a, 0x64, 0x6f, 0x62, 0x69, 0x65, 0x0a, 0x57, 0x69, 0x64, 0x7a, 0xea,
	0x20, 0x69, 0x20, 0x6f, 0x70, 0x69, 0x73, 0x75, 0x6a, 0xea, 0x2c, 0x20,
	0x62, 0x6f, 0x20, 0x74, 0xea, 0x73, 0x6b, 0x6e, 0x69, 0xea, 0x20, 0x70,
	0x6f, 0x20, 0x74, 0x6f, 0x62, 0x69, 0x65, 0x2e, 0x0a, 0x00
};

static void check_fix_utf8(void) {
	gchar *cleaned;

	g_assert(!g_utf8_validate(input_iso, -1, NULL));

	cleaned = g_strdup(input_iso);
	ekg_fix_utf8(cleaned);
	g_assert(g_utf8_validate(cleaned, -1, NULL));

	g_free(cleaned);
}

static void check_recode_charp(void) {
	gchar *utf;
	char *iso;

	/* XXX: failable? */

	utf = ekg_recode_from("iso-8859-2", input_iso);
	g_assert(strcmp(input_iso, utf));
	g_assert(g_utf8_validate(utf, -1, NULL));

	iso = ekg_recode_to("iso-8859-2", utf);
	g_assert(!strcmp(input_iso, iso));

	g_free(utf);
	g_free(iso);
}

void add_recode_tests(void) {
	g_test_add_func("/recode/ekg_fix_utf8()", check_fix_utf8);
	g_test_add_func("/recode/ekg_recode_from() & ekg_recode_to()", check_recode_charp);
}
